<?php

/* Template Name: Team */

get_header();

if ( have_posts() ) : the_post(); ?>
    <div class="custom-team" id="move-body">
        <div class="container">
            <h2><?php the_field('team_sub_title'); ?></h2>
            <h1><?php the_title(); ?></h1>
            <div class="row">
                <div class="col-lg-8">
                    <?php the_content(); ?>
                </div>
            </div>

            <div class="row">
                <?php
                if( have_rows('team_member') ) {
                    while ( have_rows('team_member') ) {
                        the_row();
                        $tel = get_sub_field('telephone');
                        $tel = str_replace(' ', '', $tel);
                        ?>
                        <div class="col-md-6 col-lg-3">
                            <div class="team-member-item">
                                <img src="<?php the_sub_field('team_image'); ?>" alt="<?php the_sub_field('name'); ?>">
                                <div class="content-area">
                                    <h3><?php the_sub_field('name'); ?></h3>
                                    <ul>
                                        <?php if(get_sub_field('title')) : ?><li class="title"><?php the_sub_field('title'); ?></li><?php endif; ?>
                                        <?php if(get_sub_field('email')) : ?><li><span class="highlight">E</span>: <a href="mailto:<?php the_sub_field('email'); ?>"><?php the_sub_field('email'); ?></a></li><?php endif; ?>
                                        <?php if(get_sub_field('telephone')) : ?><li><span class="highlight">T</span>: <a href="tel:<?php echo $tel; ?>"><?php the_sub_field('telephone'); ?></a></li><?php endif; ?>
                                        <?php if(get_sub_field('linked_in')) : ?><li class="linkedin"><a href="<?php the_sub_field('linked_in'); ?>">LinkedIn</a></li><?php endif; ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    <?php }
                }
                ?>
            </div>
        </div>
    </div>
<?php endif;
get_footer(); ?>
