<?php /* Template Name: Holding Page */ 
get_header();
$video = get_field('holding_video');
$img = get_field('holding_logo');
?>
<div class="holidng-template">
    <?php if($video) {  ?>
        <video autoplay muted loop id="myVideo">
            <source src="<?= $video['url']; ?>" type="video/mp4">
        </video>
    <?php } ?>

    <div class="video-overlay d-flex align-items-center justify-content-center">
        <div class="inner">
            <img src='<?= $img['url'] ?>' alt='Ace Aquatec'>
            <h2><?php the_field('holding_message'); ?></h2>
            <ul>
                <li>T: <a href='tel:<?php the_field('company_telephone_number', 'option'); ?>'><?php the_field('company_telephone_number', 'option'); ?></a></li>
                <li>E: <a href='mailto:<?php the_field('company_email', 'option'); ?>'><?php the_field('company_email', 'option'); ?></a></li>
            </ul>
            <ul class="social-ul">
                <?php
                if( have_rows('social_media', 'option') ):
                    while ( have_rows('social_media', 'option') ) : the_row(); ?>
                        <li>
                            <a href="<?php the_sub_field('social_media_link'); ?>" target="_blank">
                                <div class="fa-2x fa-stack-items">
                            <span class="fa-layers fa-fw">
                            <i class="fas fa-circle"></i>
                            <i class="fa-inverse fab <?php the_sub_field('social_media_fa_class') ?>" data-fa-transform="shrink-6"></i>
                        </span>
                                </div>
                            </a>
                        </li>
                    <?php endwhile;
                endif;
                ?>
            </ul>
        </div>
    </div>
</div>
<div class="introduction-section" id="scroll-here">
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <h2><?php the_field('holding_introduction_title'); ?></h2>
                <?php the_field('holding_introduction_content'); ?>
            </div>
            <div class="col-lg-6">
                <div class="blue-section" style="background-image:url('<?= get_template_directory_uri() . '/dist/images/animation-testing/overlays/blue-background-intro.png'; ?>')">
                    <?php
                    $link = get_field('holding_introduction_blue_link');
                    $img = get_field('holding_introduction_blue_image');
                    ?>
                    <?php if($img) { ?><img src="<?= $img; ?>"><?php } ?>
                    <?php the_field('introduction_blue_content'); ?>
                    <a href="<?= $link['url']; ?>"><?= $link['title']; ?></a>
                </div>
            </div>
        </div>

        <div class="swiper-container award-swiper">
            <div class="swiper-wrapper">
                <?php if( have_rows('awards', 'option') ) { ?>
                    <?php while ( have_rows('awards', 'option') ) {  the_row();
                    $award_logo = get_sub_field('award_logo');
                    ?>
                        <div class="swiper-slide">
                            <img src="<?= $award_logo['url'];  ?>" alt="<?php the_sub_field('award_title'); ?>">
                        </div>
                    <?php } ?>
                <?php } ?>
            </div>
            <div class="swiper-button-prev">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 27 44"><path d="M0,22L22,0l2.1,2.1L4.2,22l19.9,19.9L22,44L0,22L0,22L0,22z"></svg>
            </div>
            <div class="swiper-button-next">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 27 44"><path d="M27,22L27,22L5,44l-2.1-2.1L22.8,22L2.9,2.1L5,0L27,22L27,22z"></svg>
            </div>
        </div>
    </div>
</div>