<?php
/*Template Name: Frontpage Template */
get_header(); ?>

<?php get_template_part('/templates/parts/hero-carousel'); ?>

<div class="who-we-work-for">
    <div class="container">
        <div class="row">
            <div class="col-sm-12">
                <h2>Who we work with</h2>
            </div>
            <div class="col-lg-12">
                <?php if( have_rows('clients') ) { ?>
                    <div class="row">
                        <?php while ( have_rows('clients') ) {  the_row(); ?>

                            <?php $delay = get_row_index() * 100; ?>

                            <div class="col-6 col-md-4 col-lg-2 text-center">
                                <?php if(get_sub_field('link')) { ?><a href="<?php the_sub_field('link'); ?>"><?php } ?>
                                    <img src="<?php the_sub_field('image'); ?>" alt="<?php the_sub_field('name'); ?>">
                                <?php if(get_sub_field('link')) { ?> </a><?php } ?>
                            </div>
                        <?php } ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>

<div class="introduction-section" id="scroll-here">
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <h2><?php the_field('introduction_title'); ?></h2>
                <?php the_field('introduction_content'); ?>
            </div>
            <div class="col-lg-6">
                <div class="blue-section" style="background-image:url('<?= get_template_directory_uri() . '/dist/images/animation-testing/overlays/blue-background-intro.png'; ?>')">
                    <?php
                    $link = get_field('introduction_blue_link');
                    $img = get_field('introduction_blue_image');
                    ?>
                    <?php if($img) { ?><img src="<?= $img; ?>"><?php } ?>
                    <?php the_field('introduction_blue_content'); ?>
                    <a href="<?= $link['url']; ?>"><?= $link['title']; ?></a>
                </div>
            </div>
        </div>

        <div class="swiper-container award-swiper">
            <div class="swiper-wrapper">

                <?php if( have_rows('awards', 'option') ) { ?>
                    <?php while ( have_rows('awards', 'option') ) {  the_row();
                    $award_logo = get_sub_field('award_logo');
                    ?>
                        <div class="swiper-slide">
                            <img src="<?= $award_logo['url'];  ?>" alt="<?php the_sub_field('award_title'); ?>">
                        </div>
                    <?php }
                } ?>
            </div>

            <div class="swiper-button-prev">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 27 44"><path d="M0,22L22,0l2.1,2.1L4.2,22l19.9,19.9L22,44L0,22L0,22L0,22z"></svg>
            </div>
            <div class="swiper-button-next">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 27 44"><path d="M27,22L27,22L5,44l-2.1-2.1L22.8,22L2.9,2.1L5,0L27,22L27,22z"></svg>
            </div>
        </div>

    </div>
</div>

<?php get_template_part('/templates/parts/video-section'); ?>

<div class="content-section" style="background-image:url('<?= get_template_directory_uri() . '/dist/images/animation-testing/waves-h.png'; ?>')">
    <div class="container">
        <div class="row top-row">
            <div class="col-sm-6 left-side">
                <h2>The problems we solve</h2>
            </div>
            <div class="col-sm-6 text-sm-right right-side d-flex align-items-center justify-content-sm-end">
                <h2><a href="/products/">View All Products</a></h2>
            </div>
        </div>

        <?php if( have_rows('block') ) { ?>
            <div class="row block-row latest-news-section">
                <?php while ( have_rows('block') ) {  the_row();

                    if(get_sub_field('block_size_small')){
                        $cols = 'col-md-6 col-lg-4';
                    }else{
                        $cols = 'col-md-6';
                    }

                    ?>
                    <div class="<?= $cols; ?>">
                        <a href="<?php the_sub_field('link') ?>">
                            <div class="home-post-display quarter" style="background-image:url('<?= get_template_directory_uri() . '/dist/images/animation-testing/aa-placeholder.png'; ?>')">
                                <div class="inner-info" data-aos="fade-right" data-aos-delay="500">
                                    <h2><?php the_sub_field('title'); ?></h2>
                                    <div class="latest-news-excerpt"><?php the_sub_field('description'); ?></div>
                                    <h3>Find out more</h3>
                                </div>
                                <img src="<?php the_sub_field('image'); ?>"  data-aos="fade-right" data-aos-delay="250">
                                <img class='news-coloured-overlay' src="<?php the_sub_field('overlay_image') ?>" alt="Image Overlay">
                            </div>
                        </a>
                    </div>
                <?php } ?>
            </div>
        <?php } ?>
    </div>
</div>

<div class="case-study-block" style="background-image:url('<?php the_field('case_block_background'); ?>');">
    <div class="container">
        <?php
        $case = get_field('case_study_showcase');
        ?>
        <div class="row">
            <div class="col-lg-8">
                <div class="block-info">
                    <h2><?php the_field('case_study_text'); ?></h2>
                    <div class="buttons">
                        <a href="<?php the_permalink($case->ID); ?>">View Case Study</a>
                        <a href="/case-studies/">View All</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php get_template_part('/templates/parts/latest-news'); ?>

<?php get_footer(); ?>
