<?php /* Template Name: Company */ ?>

<?php get_header(); ?>

    <div class="banner-top" style="background-image:url('<?php the_post_thumbnail_url(); ?>')">
        <div class="banner-overlay"></div>
        <div class="container d-flex align-items-center h-100">
            <h1>About Us</h1>
        </div>
    </div>

    <div class="company-custom block-white">
        <div class="container">
            <?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
                <div class="row">
                    <div class="col-lg-6">
                        <h2><?php the_field('introduction'); ?></h2>
                        <?php the_field('content_block_top'); ?>
                    </div>
                    <div class="col-lg-6 text-center">
                        <img src="<?php the_field('image_1') ?>" alt="Company">
                    </div>
                </div>
            <?php endwhile; endif; ?>
        </div>
    </div>

    <div class="company-custom block-grey">
        <div class="container">
            <div class="middle-block">
                <div class="row">
                    <div class="col-lg-5">
                        <h2><?php the_field('block_title'); ?></h2>
                    </div>
                    <div class="col-lg-7">
                        <?php the_field('block_content'); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php if(get_field('secondary_block_title')) { ?>
    <div class="company-custom block-grey">
        <div class="container">
            <div class="middle-block">
                <div class="row">
                    <div class="col-lg-5">
                        <h2><?php the_field('secondary_block_title'); ?></h2>
                    </div>
                    <div class="col-lg-7">
                        <?php the_field('secondary_block_content'); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php } ?>

    <div class="company-custom block-white">
        <div class="container">
            <div class="client-section">
                <div class="row">
                    <div class="col-lg-5">
                        <h2>Clients</h2>
                    </div>
                    <div class="col-lg-7">
                        <?php the_field('client_introduction', 'option') ?>
                        <div class="row">
                            <?php
                            if( have_rows('clients', 'option') ) {
                                while ( have_rows('clients', 'option') ) {
                                    the_row();
                                    $image = get_sub_field('client_logo');
                                    ?>
                                    <div class="col-6 col-lg-3">
                                        <img src="<?= $image['url']; ?>" alt="<?php the_sub_field('client_name'); ?>">
                                    </div>
                                <?php }
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="bottom-blocks">
        <div class="container">
            <div class="row row-eq-height">
                <div class="col-lg-6">
                    <div class="block-inner">
                        <h2><?php the_field('block_title_1') ?></h2>
                        <?php the_field('block_description_1') ?>
                        <div class="button-holder">
                            <a href="<?php the_field('block_link_1') ?>"><?php the_field('block_button_text_1') ?></a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="block-inner">
                        <h2><?php the_field('block_title_2') ?></h2>
                        <?php the_field('block_description_2') ?>
                        <div class="button-holder">
                            <a href="<?php the_field('block_link_2') ?>"><?php the_field('block_button_text_2') ?></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php get_footer(); ?>
