<?php

get_header();

$hero = get_field('hero_image');

if($hero){
    $img = get_field('hero_image');
} else{
    $img = get_template_directory_uri() . '/dist/images/cat-default.jpg';
}
?>
    <div class="product-full" style="background-image:url('<?= get_template_directory_uri() . '/dist/images/animation-testing/waves-h.png'; ?>')">
        <?php if ( have_posts() ) {
            while ( have_posts() ) {
            the_post(); ?>
            <div class="banner-top" style="background-image:url('<?= $img ?>')">
                <div class="banner-overlay"></div>
                <div class="container d-flex align-items-center h-100">
                    <h1><?php the_field('hero_title_layout'); ?></h1>
                </div>
            </div>
            <div class="custom-single-product">
                <div class="container">
                    <div class="content-section">
                        <div class="brief">
                            <div class="row row-eq-height">
                                <div class="<?php if(get_field('key_features')) : echo 'col-lg-8'; else: echo 'col-lg-12'; endif; ?>">
                                    <div class="key-features">
                                        <?php the_content(); ?>
                                    </div>
                                </div>
                                <?php if( have_rows('key_features') ) { ?>
                                    <div class="col-lg-4">
                                        <div class="key-features">
                                            <h2>Key Features</h2>
                                            <ul>
                                                <?php while ( have_rows('key_features') ) {
                                                    the_row(); ?>
                                                    <li><?php the_sub_field('key_feature') ?></li>
                                                <?php } ?>
                                            </ul>
                                            <div class="button-holder"><a href="/enquiry/">Enquire Now</a></div>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                        <?php
                        $img1 = get_field('image_1');
                        $img2 = get_field('image_2');
                        if($img1 && $img2) { ?>
                            <div class="images">
                                <div class="row">
                                    <div class="col-md-6">
                                        <img src="<?= $img1['url'] ?>" class="first" alt="<?= get_the_title() . ' 1'; ?>">
                                    </div>
                                    <div class="col-md-6">
                                        <img src="<?= $img2['url'] ?>" class="second" alt="<?= get_the_title() . ' 2'; ?>">
                                    </div>
                                </div>
                            </div>
                        <?php }
                        $tab_title_count = 0;
                        $tab_content_count = 0;
                        if( have_rows('tabs') ) { ?>
                        <div class="custom-tabs">
                            <div class="nav nav-tabs align-items-center" id="nav-tab" role="tablist">
                                <?php while ( have_rows('tabs') ) {
                                    the_row();
                                    $tab_title_count++; ?>
                                    <a class="col-md-6 col-lg nav-item nav-link <?php if($tab_title_count == 1): echo 'active'; endif; ?>" id="nav-tab-<?php echo $tab_title_count; ?>" data-toggle="tab" href="#nav-tab-ref-<?php echo $tab_title_count; ?>" role="tab" aria-controls="nav-tab-<?php echo $tab_title_count; ?>" aria-selected="<?php if($tab_title_count == 1): echo 'true'; endif; ?>"><?php the_sub_field('tab_title') ?></a>
                                <?php } ?>
                            </div>
                            <?php } ?>

                            <?php if( have_rows('tabs') ) { ?>
                            <div class="tab-content" id="nav-tabContent">
                                <?php while ( have_rows('tabs') ) {
                                    the_row();
                                    $tab_content_count++; ?>
                                    <div class="tab-pane fade <?php if($tab_content_count == 1): echo 'show active'; endif; ?>" id="nav-tab-ref-<?php echo $tab_content_count; ?>" role="tabpanel" aria-labelledby="nav-tab-<?php echo $tab_content_count; ?>"><?php the_sub_field('tab_content'); ?></div>
                                <?php } ?>
                            </div>
                        </div>
                    <?php }
                    if(get_field('clients')) {  ?>
                            <div class="custom-clients">
                                <h2>Clients</h2>
                                <?php if( have_rows('clients') ) { ?>
                                    <div class="row">
                                        <?php while ( have_rows('clients') ) {
                                            the_row();
                                            $delay = 100 * get_row_index();
                                            $img = get_sub_field('client_image'); ?>
                                            <div class="col-12 col-sm-6 col-md-4 col-lg-3 col-xl-2 d-flex justify-content-center"><img src="<?php echo $img['url']; ?>" alt="<?php $img['title'] ?>" class="img-responsive" data-aos="fade-right" data-aos-delay="<?= $delay; ?>"></div>
                                        <?php } ?>
                                    </div>
                                <?php } ?>
                            </div>
                        <?php }  ?>
                    </div>
                </div>
                <?php }
                }
                if(get_field('related_case_studies')) {  ?>
                    <div class="related-case-studies">
                        <div class="container">
                            <div class="row">
                                <?php
                                $case_studies = get_field('related_case_studies');
                                foreach($case_studies as $key => $case) {
                                    setup_postdata($case); ?>
                                    <?php if($key == 0) {  ?>
                                        <div class="col-12">
                                            <h2>Related Case Study</h2>
                                            <div class="case-study-relation primary">
                                                <div class="row h-100 no-gutters">
                                                    <div class="col-lg-6">
                                                        <?php
                                                        $date = new DateTime($case->post_date);
                                                        $check = has_post_thumbnail($case->ID);
                                                        if($check == true) {
                                                            $url = get_the_post_thumbnail_url($case->ID);
                                                        }else{
                                                            $url = '';
                                                        }
                                                        ?>
                                                        <div class="img-section" style="background-image:url('<?= $url; ?>')">
                                                            <a href="<?php the_permalink($case->ID); ?>" class="overlay"><i class="fas fa-arrow-right"></i></a>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-6">
                                                        <div class="content-section">
                                                            <h3><?= $case->post_title; ?></h3>
                                                            <p>Date Posted: <?= $date->format('dS M Y'); ?></p>
                                                            <?php the_excerpt(); ?>
                                                            <p><a href="<?php the_permalink($case->ID); ?>">Read More</a></p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php } ?>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                <?php }
                if(get_field('related_products')) {  ?>
                <div class="related-products">
                    <div class="container">
                        <h2>Related Products</h2>
                        <div class="row">
                            <?php
                            $products = get_field('related_products');
                            foreach($products as $key => $product) {
                                setup_postdata($product);
                                $delay = $key * 100;
                                $categories = get_the_category($product->ID);
                                $imageDir = get_template_directory_uri() . '/dist/images/animation-testing/';
                                ?>

                                <div class="col-md-6 col-lg-4 col-xl-3">
                                    <a href="<?php the_permalink($product->ID); ?>">
                                        <?php
                                        if(get_the_post_thumbnail_url($product->ID)){
                                            $img = get_the_post_thumbnail_url($product->ID);
                                            $class = '';
                                        }else{
                                            $img = $imageDir . '/aa-placeholder.png';
                                            $class = 'default-placeholder';
                                        }
                                        ?>
                                        <div class="home-post-display quarter <?= $class; ?>" style="background-image:url('<?= $img ?>')"  data-aos="fade-right" data-aos-delay="<?= $delay; ?>">

                                            <img class='news-coloured-overlay' src="<?php the_field('product_overlay'); ?>" alt="Image Overlay">

                                            <div class="inner-info">
                                                <h2><?= $product->post_title; ?></h2>
                                                <h3>View Product</h3>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
<?php get_footer(); ?>
