<?php get_header();
$client_name = get_field('client_name');
?>
<div class="single-case" id="move-body">
    <div class="container">
        <div class="case-cont">
            <h1><?php the_title();  ?></h1>
            <img src="<?php the_post_thumbnail_url(); ?>" class="featured" alt="<?php the_title(); ?>">
            <div class="case-single-block">
                <div class="row no-gutters">
                    <div class="col-lg-3">
                        <h2><?php the_field('overview_block_title'); ?></h2>
                    </div>
                    <div class="col-lg-9 text-side">
                        <?php the_field('overview'); ?>
                        <?php if($client_name) : ?>
                            <ul class="info-block">
                                <li>Client Name: <?php the_field('client_name'); ?></li>
                                <li>Awards: <?php the_field('awards'); ?></li>
                                <li>Team Members: <?php the_field('team_members'); ?></li>
                            </ul>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="case-single-block">
                <div class="row no-gutters">
                    <div class="col-lg-3">
                        <h2><?php the_field('challenge_block_title'); ?></h2>
                    </div>
                    <div class="col-lg-9 text-side">
                        <?php the_field('challenge'); ?>
                        <?php if(get_field('image_1')) {  ?>
                            <img src="<?php the_field('image_1') ?>" alt="<?php the_field('challenge_block_title'); ?>">
                        <?php } ?>
                    </div>
                </div>
            </div>

            <div class="case-single-block">
                <div class="row no-gutters">
                    <div class="col-lg-3">
                        <h2><?php the_field('solution_block_title'); ?></h2>
                    </div>
                    <div class="col-lg-9 text-side">
                        <?php the_field('solution'); ?>
                        <?php if(get_field('image_2')) {  ?>
                            <img src="<?php the_field('image_2') ?>">
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php if(get_field('products_mentioned')) {  ?>
    <div class="product-block">
        <div class="container">
            <?php
            $products = get_field('products_mentioned');
            foreach($products as $product){
                setup_postdata($product); ?>
                <div class="product-block-single">
                    <div class="row no-gutters">
                        <div class="col-md-6">
                            <div class="image-side" style="background-image:url('<?php echo get_the_post_thumbnail_url($product->ID); ?>')">
                                <a href="<?php the_permalink($product->ID); ?>" class="overlay"><i class="fas fa-arrow-right"></i></a>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="content-side">
                                <h2><?php echo $product->post_title; ?></h2>
                                <?php
                                $terms = get_the_category($product->ID);

                                if( $terms ) { ?>
                                    <ul class="product-categories">
                                        <span>Category: </span>
                                        <?php foreach( $terms as $term ) { ?>
                                            <li><a href="<?php echo get_term_link( $term ); ?>"><?php echo $term->name; ?></a></li>
                                        <?php } ?>
                                    </ul>
                                <?php } ?>

                                <?php the_excerpt(); ?>

                                <div class="button-holder">
                                    <a href="/enquiry/">Enquire Now</a>
                                    <a href="<?php the_permalink($product->ID); ?>">View Product</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
<?php } ?>
<?php get_footer(); ?>
