import AOS from "aos";
import "aos/dist/aos.css";
import Swiper from "swiper";
import "swiper/dist/css/swiper.css";

const common = () => {
    $('.positioned-content').addClass('animated');

    $('.form-title-block').on('touchstart click', function () {
        $(".enquiry-block").toggleClass('moved');
    });

    $('.scroll-for-more a').click(function(event){
        $('html, body').animate({
            scrollTop: $( $.attr(this, 'href') ).offset().top - 130
        }, 500);
        event.preventDefault();
    });

    AOS.init();

    var mySwiper = new Swiper ('.swiper-container', {
        // Optional parameters
        direction: 'horizontal',
        loop: true,
        slidesPerView: 5,

        breakpoints: {
            600: {
                slidesPerView: 1,
                spaceBetweenSlides: 50
            },
            800: {
                slidesPerView: 2,
                spaceBetweenSlides: 50
            },
            992: {
                slidesPerView: 3,
                spaceBetweenSlides: 50
            },
            1400: {
                slidesPerView: 4,
                spaceBetweenSlides: 50
            }
        },

        // Navigation arrows
        navigation: {
            nextEl: '.swiper-button-next',
            prevEl: '.swiper-button-prev',
        },
    })
    
    $(window).scroll(function(){
        if ($(window).scrollTop() > 200){
            $('.header-nav').addClass('reduced');
        }
        if ($(window).scrollTop() < 130){
            $('.header-nav').removeClass('reduced');
        }
    });

    if ($(window).scrollTop() > 200){
            $('.header-nav').addClass('reduced');
    }
    if ($(window).scrollTop() < 130){
        $('.header-nav').removeClass('reduced');
    }

}

export default common;
