<div class="latest-news-section">
    <div class="container">
        <div class="row">
            <div class="col-sm-6 news-top"><h2>Latest News</h2></div>
            <div class="col-sm-6 news-top date-side"><h2><a href="/news/">View All News</a></h2></div>
        </div>
        <div class="row">
            <?php
            $args = array(
                'posts_per_page' => 3,
                'post_status' => 'publish',
            );
            // the query
            $the_query = new WP_Query( $args ); ?>
            <?php if ( $the_query->have_posts() ) : ?>
                <?php while ( $the_query->have_posts() ) : $the_query->the_post();
                    $row_index = $the_query->current_post + 1;
                    $term = get_the_terms(get_the_ID(), 'news-type');

                    $row_delay = $row_index * 250;

                    ?>

                    <?php if($row_index == 1):

                        ?>
                        <div class="col-lg-6">
                            <a href="<?php the_permalink(); ?>">
                                <div class="home-post-display half" data-aos="fade-right" data-aos-delay="400">
                                    <div class="inner-info" data-aos="fade-right" data-aos-delay="250">
                                        <?php if(get_field('event_date')) :  ?>
                                            <div class="date-block">
                                                <?php
                                                $date = get_field('event_date', false, false);
                                                $date = new DateTime($date);
                                                ?>
                                                <p><?= $date->format('d.m'); ?></p>
                                            </div>
                                        <?php endif; ?>
                                        <h2><?php the_title(); ?></h2>
                                        <div class="latest-news-excerpt">
                                            <?php the_excerpt(); ?>
                                        </div>
                                        <h3><span class="cat">Category: <?= $term[0]->name; ?></span><span class="dat">Posted On: <?= get_the_date('d.m'); ?></span></h3>
                                    </div>
                                    <img class='the-img' src="<?php the_post_thumbnail_url(); ?>" alt="<?php the_title(); ?>">
                                </div>
                            </a>
                        </div>
                    <?php else : ?>
                        <div class="col-md-6 col-lg-3">
                            <a href="<?php the_permalink(); ?>">
                                <div class="home-post-display quarter" data-aos="fade-right" data-aos-delay="<?= $row_delay ?>">
                                    <div class="inner-info">
                                        <h2><?php the_title(); ?></h2>
                                        <div class="latest-news-excerpt"><?php the_excerpt(); ?></div>
                                        <h3><span class="cat">Category: <?= $term[0]->name; ?></span><span class="dat">Posted On: <?= get_the_date('d.m'); ?></span></h3>
                                    </div>
                                    <?php if(get_the_post_thumbnail_url()){ ?>
                                        <img class='the-img' src="<?php the_post_thumbnail_url(); ?>" class="<?php the_title(); ?>">
                                    <?php } ?>
                                </div>
                            </a>
                        </div>
                    <?php endif; ?>

                <?php endwhile; ?>
                <?php wp_reset_postdata(); ?>
            <?php endif; ?>
        </div>
    </div>
</div>
