<?php

$video = get_field('video');
$img = get_field('logo');

?>

<div class="holidng-template">
    <?php if($video) {  ?>
        <video autoplay muted loop id="myVideo">
            <source src="<?= $video['url']; ?>" type="video/mp4">
        </video>
    <?php } ?>

    <div class="video-overlay d-flex align-items-center justify-content-center">
        <div class="inner">
            <img src='<?= $img['url'] ?>' alt='Ace Aquatec'>
            <h2><?php the_field('message'); ?></h2>
            <ul>
                <li>T: <a href='tel:<?php the_field('company_telephone_number', 'option'); ?>'><?php the_field('company_telephone_number', 'option'); ?></a></li>
                <li>E: <a href='mailto:<?php the_field('company_email', 'option'); ?>'><?php the_field('company_email', 'option'); ?></a></li>
            </ul>
            <ul class="social-ul">
                <?php
                if( have_rows('social_media', 'option') ):
                    while ( have_rows('social_media', 'option') ) : the_row(); ?>
                        <li>
                            <a href="<?php the_sub_field('social_media_link'); ?>" target="_blank">
                                <div class="fa-2x fa-stack-items">
                            <span class="fa-layers fa-fw">
                            <i class="fas fa-circle"></i>
                            <i class="fa-inverse fab <?php the_sub_field('social_media_fa_class') ?>" data-fa-transform="shrink-6"></i>
                        </span>
                                </div>
                            </a>
                        </li>
                    <?php endwhile;
                endif;
                ?>
            </ul>
        </div>
    </div>
</div>

