<?php

/* Template Name: Contact Map */

$tel = get_field('company_telephone_number','option');
$tel = str_replace(' ', '', $tel);

$title = get_field('title') ?? "";
$titleText = get_field('title_text') ?? "";

?>

<?php get_header(); ?>
<div class="contact-custom" id="move-body">
    <div class="container">
        <?php if ( have_posts() ) { while ( have_posts() ) { the_post(); ?>
        <div class="row d-flex">
            <?php if (($title !== "") || ($titleText !== "")) { ?>
            <div class="col-12 map-container">
                <?= (($title !== "") ? "<h1>".$title."</h1>" : ""); ?>
                <?= (($titleText !== "") ? "<p>".$titleText."</p>" : ""); ?>
            </div>
            <?php } ?>
            <div class="col-10 col-xl-8 d-none d-lg-block map-container map-container-map">
                <img src="<?= get_template_directory_uri() . '/dist/images/Ave-World-Map.svg'; ?>">
                <a class="pin" id="pin1"></a>
                <a class="pin" id="pin2"></a>
                <a class="pin" id="pin3"></a>
                <a class="pin" id="pin4"></a>
                <a class="pin" id="pin5"></a>
            </div>
            <div class="col-12 map-container">
                <div class="col-lg-12 contact-blocks" id="contact-blocks">
                    <div class="inner col-lg-4" id="block1">
                            <div class="contact-block">
                                <div class="row">
                                    <div class="col-12 address">
                                        <?php the_field('company_address', 'option'); ?>
                                    </div>
                                    <div class="col-12 contact-details">
                                        <?php if(get_field('company_telephone_number', 'option')) { ?><p>T: <a href="tel:<?= $tel; ?>"><?php the_field('company_telephone_number', 'option'); ?></a></p><?php } ?>
                                        <?php if(get_field('company_email', 'option')) { ?><p>E: <a href="mailto:<?php the_field('company_email', 'option'); ?>"><?php the_field('company_email', 'option'); ?></a></p><?php } ?>
                                        <?php if(get_field('company_sales_email', 'option')) { ?><p>E: <a href="mailto:<?php the_field('company_sales_email', 'option'); ?>"><?php the_field('company_sales_email', 'option'); ?></a></p><?php } ?>
                                        <?php if(get_field('company_map_image', 'option')) { ?><img src="<?php the_field('company_map_image', 'option'); ?>"></img><?php } ?>
                                        <?php if(get_field('company_directions_link', 'option')) { ?><a class="directions-link" target="_blank" href="<?php the_field('company_directions_link', 'option'); ?>">Get Directions</a><?php } ?>
                                    </div>
                                </div>
                            </div>
                    </div>
                    <?php
                        if (have_rows('extra_contact_details', 'options')) {
                            $blockCounter = 2;
                            while (have_rows('extra_contact_details', 'options')) {
                                the_row();
                    ?>  
                                <div class="inner col-lg-4" id="block<?= $blockCounter; ?>">
                                        <div class="contact-block">                                    
                                            <div class="row">
                                                <div class="col-12 address">
                                                    <?php the_sub_field('company_address'); ?>
                                                </div>
                                                <div class="col-12 contact-details">
                                                    <?php if(get_sub_field('company_telephone_number')) { ?><p>T: <a href="tel:<?= $tel; ?>"><?php the_sub_field('company_telephone_number'); ?></a></p><?php } ?>
                                                    <?php if(get_sub_field('company_email')) { ?><p>E: <a href="mailto:<?php the_sub_field('company_email'); ?>"><?php the_sub_field('company_email'); ?></a></p><?php } ?>
                                                    <?php if(get_sub_field('company_sales_email')) { ?><p>E: <a href="mailto:<?php the_sub_field('company_sales_email'); ?>"><?php the_sub_field('company_sales_email'); ?></a></p><?php } ?>
                                                    <?php if(get_sub_field('company_map_image')) { ?><img src="<?php the_sub_field('company_map_image'); ?>"></img><?php } ?>
                                                    <?php if(get_sub_field('company_directions_link')) { ?><a class="directions-link" target="_blank" href="<?php the_sub_field('company_directions_link'); ?>">Get Directions</a><?php } ?>
                                                </div>
                                            </div>
                                        </div>
                                </div>
                    <?php     
                                $blockCounter++;
                            }
                        }
                    ?> 
                </div>
            </div>
        </div>
    </div>
    <?php }
    } ?>
</div>
<div class="contact-custom contact-form-section" style="background-color:#00213a; background-image:url('https://d1ssu070pg2v9i.cloudfront.net/pex/ace_aquatec/2018/09/20154317/navy-verve-graphic.png')">
    <div class="container">
        <div class="row d-flex">
            <div class="col-lg-12 d-flex flex-column justify-content-center">
                <h2 class="contact-titles align-self-center">General Enquiries</h2>
                <div class="inner col-lg-6 align-self-center">
                    <?= do_shortcode('[contact-form-7 id="110" title="Contact Form"]'); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php get_footer(); ?>
