<?php

get_header();
$term = get_queried_object();
$termSlug = $term->slug;
$catHero = get_field('category_hero', $term);
$img = $catHero ? get_field('category_hero', $term) : get_template_directory_uri() . '/dist/images/cat-default.jpg';

?>

    <div class="banner-top" style="background-image:url('<?= $img ?>')"></div>

    <div class="custom-category-archive">
        <div class="container">
            <div class="introduction">
                <div class="row">
                    <div class="col-lg-7">
                        <h1><?php single_cat_title(); ?></h1>
                        <?php $intro = get_field('category_introduction', $term); ?>
                        <p><?= $intro; ?></p>
                    </div>
                </div>
            </div>

            <div class="products-section">
                <h2>All Products</h2>
                <?= do_shortcode('[get_category_listing id="' . $termSlug. '" count="-1" positioning="justify-content-left" post-type="products"]'); ?>
            </div>

            <div class="products-section">
                <h2>All Case Studies</h2>
                <?= do_shortcode('[get_category_listing id="' . $termSlug. '" count="-1" positioning="justify-content-left" post-type="case-studies"]'); ?>
            </div>

        </div>
    </div>
    <div class="other-cats">
        <div class="container">
            <div class="other-categories">
                <h2>More Categories</h2>
                <div class="row">
                    <?php
                    $otherTerms = get_terms('category',array( 'parent' => 0, 'hide_empty' => true, 'exclude'=> array($term->term_id, 1) ) );

                    foreach($otherTerms as $termItem){
                        $imageDir = get_template_directory_uri() . '/dist/images/animation-testing/';
                        ?>
                        <div class="col-md-6 col-lg-3 product-archive-col">
                            <a href="<?= get_term_link($termItem); ?>">

                                <?php
                                $imageDir = get_template_directory_uri() . '/dist/images/animation-testing/';

                                if(get_field('category_hero', $termItem)){
                                    $img = get_field('category_hero', $termItem);
                                    $class = '';
                                } else {
                                    $img = "";
                                }
                                ?>

                                <div class="product-archive-item" style="background-image:url('<?= $img; ?>')">
                                    <div class="link-holder">
                                        <h2><?= $termItem->name; ?></h2>
                                        <h3>View All Products</h3>
                                    </div>
                                </div>
                            </a>
                        </div>

                    <?php } ?>
                </div>

            </div>
        </div>
    </div>

<?php get_footer(); ?>
