<?php

$imageDir = get_template_directory_uri() . '/dist/images/animation-testing/';

$image = get_the_post_thumbnail_url() ?: "";

?>



<div class="col-12 full-block-case">
    <div class="row no-gutters"  data-aos="fade-right" data-aos-delay="400">
        <div class="col-lg-8">
            <div class="inner-image">
                <a href="<?php the_permalink(); ?>">
                    <?php if($image) { ?>
                        <img src="<?= $image; ?>" alt="<?php the_title(); ?>">
                    <?php } ?>
                </a>
            </div>
        </div>
        <div class="col-lg-4">
            <div class="content-side">
                <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                <?php

                $terms = get_the_category();
                if( $terms ): ?>

                    <ul class="product-categories">

                        <?php foreach( $terms as $term ): ?>

                            <li><a href="<?php echo get_term_link( $term ); ?>"><?php echo $term->name; ?></a></li>

                        <?php endforeach; ?>
                    </ul>
                <?php endif; ?>
                <?php the_excerpt(); ?>
                <a class="case-a" href="<?php the_permalink(); ?>">Read More</a>
            </div>
        </div>
    </div>
</div>
