<?php


get_header();

$mobilePositioning = get_field('mobile_banner_positioning');

switch ($mobilePositioning) {
    case "top":
        $mobClass = 'mobile-top-position';
        break;
    case "right":
        $mobClass = 'mobile-right-position';
        break;
    case "bottom":
        $mobClass = 'mobile-bottom-position';
        break;
    case "left":
        $mobClass = 'mobile-left-position';
        break;
    default:
        $mobClass = 'mobile-center-position';
}

$content = get_post()->post_content;

?>
<div class="custom-product">
    <div class="banner">
        <div class="image-banner <?= $mobClass ?>" style="background-image:url('<?php the_field('top_banner'); ?>')"></div>
        <div class="top-banner-section">
            <div class="title-block">
                <div class="container">
                    <h1><?php the_title(); ?></h1>
                </div>
            </div>
            <?php
            if(!empty($content)){ ?>
            <div class="content-block">
                <div class="container">
                    <?php the_content(); ?>
                </div>
            </div>
            <?php }?>
        </div>
    </div>
    <div class="introduction-block" style="background-image:url('<?= get_template_directory_uri() . '/dist/images/verf-right-half.jpg'; ?>')">
        <div class="container intro-cont">
            <div class="row">
                <div class="<?= get_the_ID() !== 1440 && get_the_ID() !== 2091 && get_the_ID() !== 2092 ? 'col-lg-6' : 'col-lg-8' ?>">
                    <div class="indentation">
                    <?php if(get_the_ID() != 1440){ ?>
                        <h3>Product Intro</h3>
                    <?php } ?>
                        <h2><?php the_field('intro_title'); ?></h2>
                        <?php the_field('intro_content');
                        $cta = get_field('intro_cta');
                        if($cta){ ?>
                            <div class="cta-block">
                                <a href="<?= $cta['url']; ?>">
                                    <div class="before-section"><i class="fas fa-paper-plane"></i></div>
                                    <?= $cta['title']; ?>
                                </a>
                            </div>
                        <?php } ?>
                    </div>
                </div>
                <div class="<?= get_the_ID() !== 1440 && get_the_ID() !== 2091 && get_the_ID() !== 2092? 'col-lg-6' : 'col-lg-4' ?> d-flex gallery-col align-items-lg-end justify-content-lg-center">
                    <?php
                    $productGallery = get_field('intro_gallery');

                    if(get_the_post_thumbnail_url()) {
                        $overlapImage = get_field('overlap_featured_image');
                        ?>
                        <div class="gallery-holder <?= $overlapImage ? 'overlap' : '';?>">
                            <img src="<?php $overlapImage ? the_post_thumbnail_url('medium_large') : the_post_thumbnail_url(); ?>" alt="<?php the_title(); ?>" class="<?= $overlapImage ? 'overlay-image' : 'full-size';?> ">
                            <?php if($productGallery) { ?>
                                <div class="cta-block gallery-cta">
                                    <div class="before-section"><i class="fas fa-camera"></i></div>
                                    <a href="#gallery-popup" class="gallery-trigger">
                                        View photo gallery
                                    </a>
                                </div>
                            <?php } ?>

                            <div id="gallery-popup">
                                <?php foreach ($productGallery as $productImage) { ?>
                                    <a href="<?= $productImage['url']; ?>"></a>
                                <?php } ?>
                            </div>
                        </div>
                    <?php } else { ?>
                        <div class="form-block">
                            <?php the_field('no_featured_image') ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>

    <?php get_template_part('templates/flexible-blocks'); ?>


</div>
<?php get_footer(); ?>
