import 'bootstrap';
import '@fortawesome/fontawesome';
import '@fortawesome/fontawesome-pro-solid';
import '@fortawesome/fontawesome-pro-regular';
import '@fortawesome/fontawesome-pro-light';
import '@fortawesome/fontawesome-free-brands';
import '@babel/polyfill';
import common from './common';
import hero_animation from './parts/hero-animation';
import frontpage from './parts/frontpage';
import product_single from './parts/product-single';
import "magnific-popup/dist/jquery.magnific-popup.min.js";

/*
Basic event routing
Switch on body class that gets applied either due to page, post type or page template
Replace '-' in the class name with '_'
*/
const route = (className) => {
    //Run common code on every page
    switch (className) {
        case 'home':
            frontpage();
        case 'template_animation':
            hero_animation();
            break;
        case 'single_products':
            product_single();
            break;
        case 'template_contact':
            /* Map */
            var uluru = {lat: 56.462339, lng: -2.9622801};
            var map1 = new google.maps.Map(document.getElementById('map'), {
                zoom: 15,
                center: uluru,
                disableDefaultUI: true,
                gestureHandling: 'greedy',
                scrollwheel: false
            });

            var marker = new google.maps.Marker({
                position: uluru,
                map: map1,
                title: 'Ace Aquatec'
            });
            break;
    }
};

//Fire events once document has loaded
document.addEventListener("DOMContentLoaded", function () {
common();                                            //Run common code
    let bodyClasses = document.body.className        //Get all body classes
        .replace(/-/g, '_')                          //Replace dashes with underscores
        .replace(/page_template_/g, '')              //Remove prefix 'page_template' from template classes
        .split(/\s+/);                               //Split on whitespace
    for (let value of bodyClasses) {
        route(value);                                //Run javascript for each body class
    }
});
