<?php

/* Template Name: Contact */

$tel = get_field('company_telephone_number','option');
$tel = str_replace(' ', '', $tel);

?>

<?php get_header(); ?>
<div class="contact-custom" id="move-body">
    <div class="container">
        <?php if ( have_posts() ) { while ( have_posts() ) { the_post(); ?>
        <div class="row">
            <div class="col-lg-6">
                <h1 class="contact-titles"><?php the_title(); ?></h1>
                <div class="inner">
                    <div class="row">
                        <div class="col-xl-6 address">
                            <?php the_field('company_address', 'option'); ?>
                        </div>
                        <div class="col-xl-6 contact-details">
                            <?php if(get_field('company_telephone_number', 'option')) { ?><p>T: <a href="tel:<?= $tel; ?>"><?php the_field('company_telephone_number', 'option'); ?></a></p><?php } ?>
                            <?php if(get_field('company_email', 'option')) { ?><p>E: <a href="mailto:<?php the_field('company_email', 'option'); ?>"><?php the_field('company_email', 'option'); ?></a></p><?php } ?>
                            <?php if(get_field('company_sales_email', 'option')) { ?><p>E: <a href="mailto:<?php the_field('company_sales_email', 'option'); ?>"><?php the_field('company_sales_email', 'option'); ?></a></p><?php } ?>
                        </div>
                        <div class="col-12">
                            <?php the_content(); ?>
                        </div>
                    </div>
                </div>
                <?php
                    if (have_rows('extra_contact_details', 'options')) {
                        while (have_rows('extra_contact_details', 'options')) {
                            the_row();
                ?>  
                            <div class="inner">
                                <div class="row">
                                    <div class="col-xl-6 address">
                                        <?php the_sub_field('company_address'); ?>
                                    </div>
                                    <div class="col-xl-6 contact-details">
                                        <?php if(get_sub_field('company_telephone_number')) { ?><p>T: <a href="tel:<?= $tel; ?>"><?php the_sub_field('company_telephone_number'); ?></a></p><?php } ?>
                                        <?php if(get_sub_field('company_email')) { ?><p>E: <a href="mailto:<?php the_sub_field('company_email'); ?>"><?php the_sub_field('company_email'); ?></a></p><?php } ?>
                                        <?php if(get_sub_field('company_sales_email')) { ?><p>E: <a href="mailto:<?php the_sub_field('company_sales_email'); ?>"><?php the_sub_field('company_sales_email'); ?></a></p><?php } ?>
                                    </div>
                                </div>
                            </div>
                <?php     
                        }
                    }
                ?> 
            </div>
            <div class="col-lg-6">
                <h2 class="contact-titles">General Enquiries</h2>
                <div class="inner">
                    <?= do_shortcode('[contact-form-7 id="110" title="Contact Form"]'); ?>
                </div>
            </div>
        </div>
    </div>
    <?php }
    } ?>
</div>
</div>
<div class="map-area" id="map"></div>
<?php get_footer(); ?>
