const webpack = require("webpack");
// This is used to clean the dist folder at the start of the build
const CleanWebpackPlugin = require("clean-webpack-plugin");

// This is used to copy image files from source to dist)
const CopyWebpackPlugin = require("copy-webpack-plugin");

const MiniCssExtractPlugin = require("mini-css-extract-plugin");
// This is used to auto-reload browsers
const BrowserSyncPlugin = require("browser-sync-webpack-plugin");

const devMode = process.env.NODE_ENV !== "production";

module.exports = function(env) {
  var entry = ["./assets/scripts/app.js", "./assets/styles/main.scss"];

  var distPath = __dirname + "/../dist";

  var devUrl = "ace-aquatec-dev.test";

  return {
    entry: entry,
    output: {
      path: distPath,
      publicPath: `/content/themes/ace-aquatec/dist/`,
      filename: "site.js"
    },
    module: {
      rules: [
        {
          test: /\.js$/,
          exclude: /node_modules/,
          use: {
            loader: "babel-loader"
          }
        },
        {
          test: /\.(jpe?g|png|gif)$/,
          use: [
            {
              loader: "url-loader"
            }
          ]
        },
        {
          test: /\.svg$/,
          loader: "svg-inline-loader"
        },
        {
          test: /\.(sa|sc|c)ss$/,
          use: [
            MiniCssExtractPlugin.loader,
            {
              loader: "css-loader", // translates CSS into CommonJS modules
              options: {
                sourceMap: true
              }
            },
            'resolve-url-loader',
            {
              loader: "postcss-loader", // Run post css actions
              options: {
                sourceMap: true,
                config: {
                  path: __dirname
                }
              }
            },
            {
              loader: "sass-loader", // compiles SASS to CSS
              options: {
                sourceMap: true
              }
            }
          ]
        },
        {
          test: /\.(ttf|eot|woff|woff2)$/,
          use: {
            loader: 'file-loader',
            options: {
              name: '[name].[ext]',
              outputPath: './fonts'
            }
          }
        }
      ]
    },
    externals: {
      jquery: "jQuery"
    },
    plugins: [
      new CleanWebpackPlugin([distPath], {
        verbose: true,
        allowExternal: true
      }),
      new MiniCssExtractPlugin({
        filename: "site.css"
      }),
      new CopyWebpackPlugin([
        {
          from: "assets/images/",
          to: "images",
          ignore: ['*.gitignore']
        }
      ]),
      new webpack.ProvidePlugin({
        $: "jquery",
        jQuery: "jquery",
        "window.jQuery": "jquery",
        Popper: ["popper.js", "default"]
      }),
      new BrowserSyncPlugin({
        proxy: devUrl
      })
    ]
  };
};
