<?php
$primaryBlock = get_sub_field('primary_block');
$secondaryBlock = get_sub_field('secondary_block');

$blockRatio = get_sub_field('block_ratio');

switch ($blockRatio) 
{
    case '75-25':
        $primaryBlockCol = 'col-lg-9';
        $secondaryBlockCol = 'col-lg-3';
        break;
    case '25-75':
        $primaryBlockCol = 'col-lg-4';
        $secondaryBlockCol = 'col-lg-8';
        break;
    case '50-50':
        $primaryBlockCol = 'col-lg-6';
        $secondaryBlockCol = 'col-lg-6';
        break;
	case '60-40':
        $primaryBlockCol = 'col-lg-8';
        $secondaryBlockCol = 'col-lg-4';
        break;
	case '40-60':
        $primaryBlockCol = 'col-lg-4';
        $secondaryBlockCol = 'col-lg-8';
        break;
}
?>

<div class="standalone-flexible-block split-block">
    <div class="container">

        <div class="row">
            <div class="<?= $primaryBlockCol; ?> primary-col">
                <div class="primary-block inner-block">
                    <?php if($primaryBlock['block_type'] == 'content') { ?>
                        <div class="content-block">
                            <?php if($primaryBlock['title']) { ?><h2><?= $primaryBlock['title']; ?></h2><?php } ?>
                            <div class="description"><?= $primaryBlock['content']; ?></div>
                        </div>
                    <?php } elseif($primaryBlock['block_type'] == 'image') { ?>
                        <div class="image-block">
                            <img src="<?= $primaryBlock['image']['url']; ?>" alt="<?= $primaryBlock['image']['alt']; ?>" loading="lazy">
                        </div>
                    <?php } ?>
                </div>
            </div>
            <div class="<?= $secondaryBlockCol; ?> secondary-col">
                <div class="secondary-block inner-block">
                    <?php if($secondaryBlock['block_type'] == 'content') { ?>
                        <div class="content-block">
                            <?php if($secondaryBlock['title']) { ?><h2><?= $secondaryBlock['title']; ?></h2><?php } ?>
                            <div class="description"><?= $secondaryBlock['content']; ?></div>
                        </div>
                    <?php } elseif($secondaryBlock['block_type'] == 'image') { ?>
                        <div class="image-block">
                            <img src="<?= $secondaryBlock['image']['url']; ?>" alt="<?= $secondaryBlock['image']['alt']; ?>" loading="lazy">
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>


    </div>
</div>
