<?php

get_header();

$custom_id = get_the_ID();
?>
    <div class="custom-single-post" id='move-body'>
        <div class="container">

            <p class="date">Date Posted: <?php echo get_the_date(); ?></p>
            <h1><?php the_title(); ?></h1>


            <div class="row">

                <?php if ( have_posts() ) : while ( have_posts() ) : the_post();

                    global $post;
                    $terms  = wp_get_object_terms( $post->ID, 'news-type');
                    $names  = wp_list_pluck( $terms, 'name' );
                    $term_output = implode( ', ', $names );
                    ?>
                    <div class="col-lg-8">
                        <img class = "news-img" src="<?php the_post_thumbnail_url('news-thumb'); ?>" alt="<?php the_title(); ?>">
                        <?php the_content(); ?>
                        <p class="category">Category: <?php echo $term_output; ?></p>
                        <?php if(get_field('event_date')):  ?>
                            <p class="date">Event Date: <?php echo get_field('event_date'); ?></p>
                        <?php endif; ?>
                    </div>
                <?php endwhile; endif; ?>

                <div class="col-lg-4">
                    <div class="related-news">

                        <?php
                        $args = array(
                            'post__not_in' => array($custom_id), //excludes current post id
                            'post_type' => 'post',
                            'showposts' => '5',
                        );
                        ?>

                        <h2>Related News</h2>
                        <?php query_posts( $args ); while (have_posts()) : the_post(); ?>
                            <div class="related-items d-flex flex-wrap">
                                <div class="w-25 pr-2">
                                    <img class = "img-fluid rounded-img" src="<?php the_post_thumbnail_url('thumbnail'); ?>" alt="<?php the_title(); ?>">
                                </div>
                                <div class="w-75">
                                    <p class="date">Date Posted: <?php echo get_the_date(); ?></p>
                                    <h3><?php the_title(); ?></h3>
                                    <p><a href="<?php the_permalink(); ?>">Read More</a></p>
                                </div>
                            </div>
                        <?php endwhile; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>


<?php get_footer(); ?>
