
<nav class="header-nav <?= (is_front_page() ? 'transparent-bg' : ''); ?>">
    <div class="container">
        <div class="brand-nav">
            <a class="navbar-brand" href="<?= esc_url(home_url('/')); ?>">
                <a class="navbar-brand" href="<?= esc_url(home_url('/')); ?>">
                    <img src="<?php the_field('brand_logo', 'option') ?>">
                </a>
            </a>
        </div>
        <div class="wrapper">
            <div class="nav-holder">
                <div class="top-bar d-flex align-items-center justify-content-end">
                    <?php if( have_rows('social_media', 'option') ): ?>
                        <ul class="social">
                            <?php while ( have_rows('social_media', 'option') ) : the_row(); ?>
                                <li>
                                    <a href="<?php the_sub_field('social_media_link') ?>">
                                    <span class="fa-layers fa-2x">
                                      <i class="fal fa-circle"></i>
                                      <i class="<?php the_sub_field('social_media_fa_class') ?>" data-fa-transform="shrink-8"></i>
                                    </span>
                                    </a>
                                </li>
                            <?php endwhile; ?>
                        </ul>
                    <?php endif; ?>

                    <ul class="links">
                        <li class="customer-login"><a href="<?php the_field('customer_login_link','option') ?>"><i class="fas fa-user-alt"></i> Customer Login</a></li>
                        <!--<li style="display:none;"><a href=""><i class="fas fa-globe"></i> EN <i class="far fa-chevron-down"></i></a></li>-->
                    </ul>

                    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                        Menu
                    </button>
                </div>
            </div>

            <div class="d-none d-lg-block">
                <div class="collapse navbar-collapse" id="navbarSupportedContent">
                    <?php
                    if (has_nav_menu('main_menu')) {
                        wp_nav_menu(array('theme_location' => 'main_menu', 'menu_class' => 'navigation'));
                    }
                    ?>
                </div>
            </div>
        </div>

        <div class="d-block d-lg-none mob-nav">
            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <?php
                if (has_nav_menu('main_menu')) {
                    wp_nav_menu(array('theme_location' => 'main_menu', 'menu_class' => 'navigation'));
                }
                ?>
            </div>
        </div>

    </div>
</nav>
