<?php get_header(); ?>
    <div class="single-career" id='move-body'>
        <div class="container">

            <?php
            if ( have_posts() ) {
                while ( have_posts() ) {
                    the_post(); ?>
                    <div class="row">
                        <div class="col-lg-8">
                            <div class="career-block">
                                <h2 class="top-h2"><a href="/careers/">Join Ace Aquatec</a></h2>
                                <h1><?php the_title(); ?></h1>
                                <h3 class="date">Date posted - <?php the_date(); ?></h3>
                                <?php the_content(); ?>
                                <hr/>
                                <?php
                                if( have_rows('qualifications') ): ?>
                                    <h2 class="qualifications">Qualifications</h2>
                                    <ul class="qualifications-ul">
                                        <?php while ( have_rows('qualifications') ) : the_row(); ?>
                                            <li><?php the_sub_field('qualification'); ?></li>
                                        <?php endwhile; ?>
                                    </ul>
                                <?php endif;?>

                                <div class="button-holder">
                                    <a href="mailto:<?php the_field('careers_email_address', get_the_id() )  ?>" class="apply-now">Apply Now</a>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="sidebar">
                                <h2>Other Job Openings</h2>
                                <?php

                                $args = array(
                                    'post_type'   => 'careers',
                                    'exclude' => get_the_ID()
                                );

                                $careers = get_posts( $args );

                                foreach($careers as $career){ ?>
                                    <div class="sidebar-career">
                                        <p><a href="<?php the_permalink($career->ID); ?>"><?php echo $career->post_title ?></a></p>
                                        <p>Date Posted - <?php echo $career->post_date ?></p>
                                        <p><a href="<?php the_permalink($career->ID); ?>">More information</a></p>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                <?php } // end while
            } // end if
            ?>
        </div>
    </div>
<?php get_footer(); ?>
