<?php
if (have_rows('flexible_blocks')) {
    while (have_rows('flexible_blocks')) {
        the_row();
        if (get_row_layout() == 'flexible_block') {

            $boxRatio = get_sub_field('box_ratio');
            $boxBackgroundColour = get_sub_field('box_background_colour');
            $boxTextColour = get_sub_field('box_text_colour');
            $boxBackgroundImage = get_sub_field('box_background_image');
            $boxPositioning = get_sub_field('box_positioning');

            $leftContentType = get_sub_field('left_panel_content');
            $rightContentType = get_sub_field('right_panel_content');
            $fullContentType = get_sub_field('full_panel_content');

            if ($boxRatio == '70-30') {
                $leftBlockCol = 'col-lg-8';
                $rightBlockCol = 'col-lg-4';
                $fullBlockCol = '';
            } else if ($boxRatio == '30-70') {
                $leftBlockCol = 'col-lg-4';
                $rightBlockCol = 'col-lg-8';
                $fullBlockCol = '';
            } else if ($boxRatio == '50-50') {
                $leftBlockCol = 'col-lg-6';
                $rightBlockCol = 'col-lg-6';
                $fullBlockCol = '';
            } else if ($boxRatio == '100') {
                $leftBlockCol = '';
                $rightBlockCol = '';
                $fullBlockCol = 'col-lg-12';
            }

            if((($leftContentType == 'Text Overlay' || $rightContentType == 'Text Overlay') && $boxRatio != '100') || ($fullContentType == 'Text Overlay' && $boxRatio == '100')){
                $boxHeight = get_sub_field('box_height') . 'px';
                $setHeight = true;
            } else {
                $boxHeight = 'auto';
                $setHeight = false;
            }
            ?>

            <div class="flexible-blocks <?= $fullContentType; ?> <?php if($setHeight) { echo 'box-set-height '; echo 'align-items-' . $boxPositioning . ''; } ?>" style="<?php if($boxHeight) { ?>height:<?= $boxHeight; ?>;<?php } ?> background-color:<?= $boxBackgroundColour; ?>; color:<?= $boxTextColour; ?>; background-image:url('<?= $boxBackgroundImage; ?>')">
                <div class="container">
                    <div class="row">


                        <?php
                        if($boxRatio == '100'){
                            $hideColsSplit = 'd-none';
                            $hideFull = '';
                        } else {
                            $hideColsSplit = '';
                            $hideFull = 'd-none';
                        }

                        ?>

                        <div class="left-block-col <?= $leftBlockCol . ' ' . $hideColsSplit; ?>">
                            <?php
                            global $topTitle;
                            global $normalTitle;
                            $topTitle = get_sub_field('left_top_title');
                            $normalTitle = get_sub_field('left_title');
                            if (have_rows('left_panel_item')) {
                                while (have_rows('left_panel_item')) {
                                    the_row();

                                    switch ($leftContentType) {
                                        case 'Image' :
                                            get_template_part('templates/flexible-blocks/image-block');
                                            break;
                                        case 'Image Listing' :
                                            get_template_part('templates/flexible-blocks/image-listing-block');
                                            break;
                                        case 'Text' :
                                            get_template_part('templates/flexible-blocks/text-block');
                                            break;
                                        case 'Text Overlay' :
                                            get_template_part('templates/flexible-blocks/text-block-overlay');
                                            break;
                                        case 'Form' :
                                            get_template_part('templates/flexible-blocks/form-block');
                                            break;
                                    }
                                }
                            }
                            ?>
                        </div>
                        <div class="right-block-col <?= $rightBlockCol . ' ' . $hideColsSplit; ?>">
                            <?php
                            global $topTitle;
                            global $normalTitle;
                            $topTitle = get_sub_field('right_top_title');
                            $normalTitle = get_sub_field('right_title');

                            if (have_rows('right_panel_item')) {
                                while (have_rows('right_panel_item')) {
                                    the_row();

                                    switch ($rightContentType) {
                                        case 'Image' :
                                            get_template_part('templates/flexible-blocks/image-block');
                                            break;
                                        case 'Image Listing' :
                                            get_template_part('templates/flexible-blocks/image-listing-block');
                                            break;
                                        case 'Text' :
                                            get_template_part('templates/flexible-blocks/text-block');
                                            break;
                                        case 'Text Overlay' :
                                            get_template_part('templates/flexible-blocks/text-block-overlay');
                                            break;
                                        case 'Form' :
                                            get_template_part('templates/flexible-blocks/form-block');
                                            break;
                                    }
                                }
                            }
                            ?>
                        </div>

                        <div class="full-block-col <?= $fullBlockCol . ' ' . $hideFull; ?>">
                            <?php
                            global $topTitle;
                            global $normalTitle;
                            $topTitle = get_sub_field('full_top_title');
                            $normalTitle = get_sub_field('full_title');

                            if (have_rows('full_panel_item')) {
                                while (have_rows('full_panel_item')) {
                                    the_row();

                                    switch ($fullContentType) {
                                        case 'Image' :
                                            get_template_part('templates/flexible-blocks/image-block');
                                            break;
                                        case 'Image Listing' :
                                            get_template_part('templates/flexible-blocks/image-listing-block');
                                            break;
                                        case 'Text' :
                                            get_template_part('templates/flexible-blocks/text-block');
                                            break;
                                        case 'Text Overlay' :
                                            get_template_part('templates/flexible-blocks/text-block-overlay');
                                            break;
                                        case 'Form' :
                                            get_template_part('templates/flexible-blocks/form-block');
                                            break;
                                        case 'CTA Block' :
                                            get_template_part('templates/flexible-blocks/cta-block');
                                            break;
                                    }
                                }
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>

        <?php }
        else if (get_row_layout() == 'content_block') {
            $content = get_sub_field('content');
            $image = get_sub_field('image');
            $subtitle = get_sub_field('subtitle');
            $buttons = get_sub_field('buttons');
            ?>
            <div class="case-study-block" style="background-image:url('<?= $image['url']; ?>');">
            <div class="container">                
                <div class="row">
                    <div class="col-lg-8">
                        <div class="block-info">
                            <h2><?= $content; ?></h2>
                            <h3><?= $subtitle; ?></h3>
                            <?php if($buttons){ ?>
                                <div class="buttons">
                                    <?php foreach($buttons as $button){ ?>
                                        <a href="<?= $button['button_link']; ?>"><?= $button['button_label'];?></a>
                                    <?php } ?>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
            <?php
        }
    }
}?>
