<?php
$primaryBlock = get_sub_field('primary_block');

$blockRatio = get_sub_field('block_ratio');

switch ($blockRatio) 
{
    case '25%':
        $primaryBlockCol = 'col-lg-3';
        break;
    case '50%':
        $primaryBlockCol = 'col-lg-6';
        break;
    case '75%':
        $primaryBlockCol = 'col-lg-9';
        break;
	case '100%':
        $primaryBlockCol = 'col-lg-12';
        break;
}
?>

<div class="standalone-flexible-block single-block">
    <div class="container">

        <div class="row">
            <div class="<?= $primaryBlockCol; ?> primary-col">
                <div class="primary-block inner-block">
                    <?php if($primaryBlock['block_type'] == 'content') { ?>
                        <div class="content-block">
                            <?php if($primaryBlock['title']) { ?><h2><?= $primaryBlock['title']; ?></h2><?php } ?>
                            <div class="description"><?= $primaryBlock['content']; ?></div>
                        </div>
                    <?php } elseif($primaryBlock['block_type'] == 'image') { ?>
                        <div class="image-block">
                            <img src="<?= $primaryBlock['image']['url']; ?>" alt="<?= $primaryBlock['image']['alt']; ?>" loading="lazy">
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</div>
