<section class="page-section section--white content-container">
    <?php
    $query = new WP_Query(array(
        'post_type' => 'team',
        'post_status' => 'publish',
        'orderby' => 'publish_date',
        'order' => 'ASC',
        'posts_per_page' => -1
    ));
    ?>
    <div class="page-section__content-secondary content-type--pop-ups full-team-wrapper d-flex flex-row flex-wrap justify-content-start full-team-row content-container__standard-content">
        
        <?php
        $currentTeam='';
        while ($query->have_posts()) {
            $query->the_post();
            $post_id = get_the_ID();
            $post_title = get_the_title();
            $post_content = get_the_content();
            if (has_post_thumbnail()){
                $img = get_the_post_thumbnail($post->ID,"portrait", array('class' => 'img-object-contain'));
            }else{
                $img='';
            }
            $title = get_field('title');
            $jobTitle = get_field('job_title');
            $team = end(explode('|', get_field('team')));
            $social_media = get_field('social_media');
            if($currentTeam!=$team){
                $currentTeam=$team;
                ?>
                <div class="col-12"><h2 class="team-heading"><?php echo $currentTeam; ?></h2></div>
                <?php
            }
            ?>               
            <div class="col col-md-6 col-lg-4 col-xxl-3">
                <div class="full-team-row__team-member <?php echo 'team-'.strtolower(str_replace(' ', '-',$team));?>">
                    <?php
                    echo $img;
                    ?>
                    <div class="team-member__title">
                        <h2 class="secondary-content-heading team-name"><?= $post_title;?></h2><span class="pop-over-icon"><i class="icon icon-mouse"></i></span>
                    </div>
                    <?php
                        if($jobTitle){
                        ?>
                        <p class="team-member__job-title"><?= $jobTitle;?></p>
                        <?php
                    }
                    ?>
                    <div class="secondary-content-text">
                        <div class="secondary-content-text-inner-text">
                            <?= $post_content;?>
                        </div>
                        <div class="team-member__social">
                        <?php
                        if ($social_media) {
                            foreach($social_media as $social_link) {
                        ?>
                            <a href="<?= $social_link['url']; ?>" target="_blank" rel="noopener">
                                <?= file_get_contents(get_template_directory_uri() . '/dist/images/' . trim($social_link['icon']) . '.svg'); ?>
                            </a>
                        <?php
                            }
                        }
                        ?>
                    </div>
                    </div>
                    
                </div>
            </div>

            <?php
        }
        wp_reset_query();
        ?>
    </div>
</section>