<?php
 //acf vars
 $section_id = get_sub_field('section_id');
 
 $heading = get_sub_field('heading');
 $case_studies = get_sub_field('case_studies');
 if(!$heading){
     $heading = 'Case Studies';
 }

?>
<section class="page-section section_articles section_articles--case-studies">
    <div class="section_articles__content  col-12">
        <h2 class="subheading"><?=$heading;?></h2>
        <?php
        if( $case_studies ): ?>
        <div class="articles-carousel--controls">
            <div class="swiper-button-prev swiper-button-prev--articles"><i class="icon icon-control-angle-left"></i></div>
            <div class="swiper-button-next swiper-button-next--articles"><i class="icon icon-control-angle-right"></i></div>
        </div>
        <div class="articles-carousel--outer">
            <div class="articles-carousel swiper--articles swiper-container">
                <div class="swiper-wrapper">
                <?php foreach( $case_studies as $case_study ): 
                    $title = $case_study['title'];
                    $img = $case_study['image'];
                    $pdf  = $case_study['pdf'];
                    ?>
                    <div class="slide swiper-slide">
                        <div class="post-item">
                            <div class="post-img">
                                <span>
                                    <img src="<?=$img['url'];?>" alt="<?= $title;?>"/>
                                </span>
                            </div>
                            <div class="post-info">
                                <h2><?= $title; ?></h2>
                                <span>Case Study</span>
                            </div>
                            <a class="btn" href="<?= $pdf; ?>" target="_blank">Read PDF</a>
                        </div>
                    </div>
                <?php endforeach; ?>
                </div>
            </div>
        </div>
            
        <?php endif; ?>
    </div>
</section>
