<?php
 //acf vars
 $is_page_header = get_sub_field('is_page_header');
 $section_id = get_sub_field('section_id');
 
 $colour = get_sub_field('colour');
 $content = get_sub_field('section_content');
 $background_image = get_sub_field('background_image');
 $mask_style = get_sub_field('background_mask_style');;
 $ken_burns = get_sub_field('ken_burns_effect');
 $secondary_content = get_sub_field('secondary_content');
 $secondary_content_rows = get_sub_field('secondary_content_rows');
 $video_bg = get_sub_field('video_background');
 $mobile_img = get_sub_field('mobile_detail_image');
 $section_classes = '';
 
 $content_classes = "col-md-6";
 $secondary_classes = "col-md-6";
     
 if($is_page_header){
     $section_tag = 'header';
     $content_classes = "col-md-7 col-lg-6";
     $secondary_classes = "col-md-5 col-lg-6";
 }else{
     $section_tag = 'section';
 }
 if($video_bg && $section_tag == 'header'){
     $background_image = '';
 }
 if($video_bg){
     $section_classes.= ' has-videobg';
 }
?>
<<?=$section_tag;?> class="page-section section--two-col section--<?=$colour;?><?=$section_classes;?>" id="<?=$section_id;?>">
    <?php if ($is_page_header){
        get_template_part( 'templates/parts/site-header' );
        }
    ?>
    <div class="page-section__content col-12 <?=$content_classes;?>">
    <?=$content;?>
    </div>
    <div class="pages-section__background-wrapper mask-style--<?=$mask_style;?>">
        <div class="pages-section__background col-12 <?=$secondary_classes;?>">
            <?php if ($background_image || $video_bg && $section_tag == 'header'){?>
            <div class="pages-section__background-inner mask-style--<?=$mask_style;?>">
                <div class="pages-section__bgimg--tint">
                    
                    <div class="pages-section__bgimg--img2" style="background-image:url(<?=$background_image['url']?>);">
                        <div class="bgimg--img2-right-mask"></div>
                    </div>
                     <svg id="overlay_A" class="overlay" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 601 542.87"><path d="M187.76,542.87S113,291.22,96.19,236s11.18-110.45,34.25-132.12,83.36-53.33,140.5-21C329,115.77,595.28,275.4,595.28,275.4l3.22-84.84L595.28,0H-2.5V542.87Z" transform="translate(2.5)"/></svg>
                    </div>
                <div class="pages-section__bgimg" style="background-image:url(<?=$background_image['url']?>);">
                    
                </div>
            </div>
             <?php
            if($video_bg && $section_tag == 'header'){
                ?>
                <video class="section--video-bg-full" muted autoplay loop playsinline>
                    <source src="<?=$video_bg['url'];?>"/>
                </video>
                <?php
                unset($video_bg);
            }
            ?>
            <?php
            }
            ?>
        </div>
       
    </div>
    <?php if($mobile_img){
        ?>
        <div class="mobile-device d-md-none">
            <img class="mobile-detail-image" src="<?=$mobile_img['url'];?>"  alt="<?=$mobile_img['title'];?>"/>   
        </div>
        <?php
    }
    ?>
    <?php if($secondary_content !== 'none'){ ?>
    <div class="page-section__content-secondary col-12 <?=$secondary_classes;?> secondary-content-type--<?=$secondary_content;?>">
        <?php 
    if( $secondary_content_rows ) {
        $divClass='';
        $divId='';
        if($secondary_content == 'circular-slides'){
            $divId = ' id="circle--rotate"';
            $divClass = ' circle--rotate';
        ?>
        <div class="circle--slider">
            <div class="rotate--circle">
        <?php
        }
    ?>
    <ul class="secondary-item<?=$divClass?>"<?=$divId?>>
    <?php
    foreach( $secondary_content_rows as $row ) {
        ?>
            <li class="block">
                <div class="li-icon"><i class="icon <?=$row['icon'];?>"></i><span> </span></div>
                <h2 class="secondary-content-heading"><?= $row['title'];?></h2><span class="pop-over-icon"><i class="icon icon-mouse"></i></span>
                <div class="secondary-content-text"><?= $row['text'];?></div>
            </li>
        <?php
    }
    ?>
    </ul>
    <?php
        if($secondary_content == 'circular-slides'){
            ?>
            <div class="animate-wrapper">
            <?php
            $i=0;
            foreach( $secondary_content_rows as $row ) {
                $i++;
            ?>            
                <div class="animate">
                  <div class="animate-img">
                    <div class="animate-img__in">
                      <div class="animate-more">
                        <span class="circle-slide-index"><?=$i;?></span>
                        <div class="animate-title">
                            <i class="icon <?=$row['icon'];?>"></i>
                          <h4><span><?=$i;?> </span><?= $row['title'];?></h4>
                          <p><?= $row['text'];?></p>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
            <?php
            }
            ?>
              </div>
              <div class="circle-slide-controls">
                  <div class="prev"><span><i class="icon icon-control-angle-left"></i></span></div>
                  <div class="next"><span><i class="icon icon-control-angle-right"></i></span></div>
              </div>
         </div>
     </div>
     <?php
         }
    }
    ?>  
    </div>
    <?php
        if($video_bg){
            ?>
            <video class="section--video-bg" muted autoplay loop playsinline>
                <source src="<?=$video_bg['url'];?>"/>
            </video>
            <?php
        }
        ?>
    <?php
        }
    ?>
</<?=$section_tag;?>>
