<?php
 //acf vars
 $section_id = get_sub_field('section_id');
 
 $heading = get_sub_field('heading');
 $sub_heading = get_sub_field('sub_heading');
 $articles = get_sub_field('articles');
?>
<section class="page-section section_articles" id="<?=$section_id;?>">
    <div class="section_articles__content  col-12">
        <h1 class="heading"><?=$heading;?></h1>
        <h2 class="subheading"><?=$sub_heading;?></h2>
        <?php
        if( $articles ): ?>
        <div class="articles-carousel--controls">
            <div class="swiper-button-prev swiper-button-prev--articles"><i class="far fa-angle-left"></i></div>
            <div class="swiper-button-next swiper-button-next--articles"><i class="far fa-angle-right"></i></div>
        </div>
        <div class="articles-carousel--outer">
            <div class="articles-carousel swiper--articles swiper-container">
                <div class="swiper-wrapper">
                <?php foreach( $articles as $post ): 
            
                    // Setup this post for WP functions (variable must be named $post).
                    setup_postdata($post); 
                    /* grab the url for the full size featured image */
                    $featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'large-square-image'); 
                    $link = get_field('external_article_link');
                    if($link){
                        $tgt='_blank';
                    }else{
                        $tgt = '_self';
                        $link = get_the_permalink();
                    }
                    ?>
                    <div class="slide swiper-slide">
                        <div class="post-item">
                            <div class="post-img">
                                <a href="<?php the_permalink(); ?>">
                                    <img src="<?=$featured_img_url;?>" alt="<?php the_title();?>"/>
                                </a>
                            </div>
                            <div class="post-info">
                                <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                                <?php
                                    $categories = get_the_category(); 
                                    if ( ! empty( $categories ) ) {
                                        echo '<span>'.esc_html( $categories[0]->name ).'</span>';   
                                    }?>
                            </div>
                            <a class="btn" href="<?= $link; ?>" target="<?= $tgt; ?>">View article</a>
                        </div>
                    </div>
                <?php endforeach; ?>
                </div>
            </div>
        </div>
            <?php 
            // Reset the global post object so that the rest of the page works correctly.
            wp_reset_postdata(); ?>
        <?php endif; ?>
    </div>
</section>
