import Headroom from "headroom.js";
// import Swiper from 'swiper';
import Swiper, { Navigation } from 'swiper';
Swiper.use([Navigation]);

const common = () => {
    console.log('This gets run on every page and is exported as the default funciton. This will require a function call to run');
    
    const myElement = document.getElementById("header-nav--headroom");
    const options = {
        offset : 200,
    }
    const headroom  = new Headroom(myElement, options);
    headroom.init();

    const articlesSwiper = new Swiper('.swiper--articles', {
        // Optional parameters
        loop: false,
        // If we need pagination
        //pagination: {
        //    el: '.swiper-pagination--articles',
        //},
        slidesPerView: 1,
        spaceBetween: 50,
        // Responsive breakpoints
        breakpoints: {
            768: {
                slidesPerView: 2,
                spaceBetween: 50
            }
        },
        // Navigation arrows
        navigation: {
            nextEl: '.swiper-button-next--articles',
            prevEl: '.swiper-button-prev--articles',
        },
    });
};

console.log('Any plain javascript will instantly run from an imported file');

export default common;
