<?php
 //acf vars
 $section_id = get_sub_field('section_id');
 
 $heading = get_sub_field('heading');
 $sub_heading = get_sub_field('sub_heading');
 $articles = get_sub_field('articles');
?>
<section class="page-section section_articles">
    <div class="col-12">
        <h1><?=$heading;?></h1>
        <h2><?=$sub_heading;?></h2>
        <?php
        if( $articles ): ?>
            <ul>
            <?php foreach( $articles as $post ): 
        
                // Setup this post for WP functions (variable must be named $post).
                setup_postdata($post); 
                /* grab the url for the full size featured image */
                $featured_img_url = get_the_post_thumbnail_url(get_the_ID(),'medium'); 
          
                /* link thumbnail to full size image for use with lightbox*/
                echo '<a href="'.esc_url($featured_img_url).'" rel="lightbox">'; 
                    the_post_thumbnail('thumbnail');
                echo '</a>';
                ?>
                <li class="post-item">
                    <div class="post-img">
                        <a href="<?php the_permalink(); ?>">
                            <img src="<?=$featured_img_url;?>" alt="<?php the_title();?>"/>
                        </a>
                    </div>
                    <div class="post-info">
                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                        <span><?php // the_field( 'field_name' ); ?></span>
                    </div>
                    <a class="btn" href="<?php the_permalink(); ?>">View article</a>
                </li>
            <?php endforeach; ?>
            </ul>
            <?php 
            // Reset the global post object so that the rest of the page works correctly.
            wp_reset_postdata(); ?>
        <?php endif; ?>
    </div>
</section>
