<?php
$query = new WP_Query(array(
    'post_type' => 'events',
    'posts_per_page' => 3,
    'orderby' => 'meta_value',
    'meta_key' => 'event_start_date',
    'order' => 'ASC',
    'meta_query' => array(
		'key' => 'event_start_date',
		'value' => date('Ymd'),
		'type' => 'DATE',
		'compare' => '>='
    )
));

if ($query->have_posts()) {
    ?>
    <section class="services-carousel">
        <div class="container">
            <h2>Latest Events</h2>
            <div class="row">
                <div class="eventsrow container">
                    <ul class="eventsul">
                        <?php while ($query->have_posts()) { ?>
                            <?php $query->the_post();
                            $featImage = wp_get_attachment_image_src(get_post_thumbnail_id(), "square-thumb") ? wp_get_attachment_image_src(get_post_thumbnail_id(), "square-thumb") : array("https://dummyimage.com/300x300/cccccc/000000.jpg&text=Pending+");
                            ?>
                            <li>
                                <div class="circled">
                                    <a href="<?php the_permalink(); ?>" class="cover-link" title="<?php the_title(); ?>"> </a>
                                    <div>
                                        <div class="img-circle">
                                            <img class="img-circle img-responsive" src="<?php echo $featImage[0]; ?>">
                                        </div>
                                        <?php include(get_template_directory().'/templates/global/event-dates.php'); ?>

                                        <h2 class="h2sub-serv"><?php the_title(); ?></h2>
                                        <p><?php echo wp_trim_words(get_the_content(), 10, '..'); ?></p>
                                    </div>


                                </div>
                            </li>
                            <?php } ?>
                    </ul>
                </div>
                <p class="text-center"> <a class="btn btn-primary" href="/events/">All events</a> </p>
            </div>
        </div>
    </section>
<?php } ?>
<?php wp_reset_postdata() ?>

