    <?php
    //Getting services for the postcode search
    $serviceMarkers = [];
    $nationWideRoles = '<ul>';
    $serviceLoop = new WP_Query(['post_type' => 'volunteering']);
    if ($serviceLoop->have_posts()) {
        $count = 0;
        while ($serviceLoop->have_posts()) {
            $serviceLoop->the_post();
            $map = get_field('google_map');
            $isNationWide=get_field('available_scotland_wide');
            if($isNationWide){
                $liClass="order-10";
            }else{
                $liClass="order-0";
            }
            if($map) {
                array_push($serviceMarkers, [get_the_title(), $map['lat'], $map['lng'], get_permalink(),$liClass]);
            }
            if($isNationWide){
                $nationWideRoles.='<li><a href="'.get_permalink().'" target="_blank">'.get_the_title().'</a></li>';
            }
        }
        $nationWideRoles.="</ul>";
    }
    wp_reset_postdata();
?>
<div class="block-6040">
    <div class="container-fluid">
        <div class="row row-eq-height find-service-row find-service-row--volunteering">
            <div class="col-lg-7 left-col" style="background-image: url('<?= get_field("service_map_image","option"); ?>'); background-position: right bottom; background-repeat: no-repeat; background-size: contain;">
                <div class="left-inner">
                    <h3><?php the_field('left_block_title_volunteering', 'option'); ?></h3>
                    <?php the_field('left_block_content_volunteering', 'option'); ?>
                </div>
            </div>
            <div class="col-lg-5 map-col">
                <div id="map-block" class="volunteering-search-map" data-services="<?= htmlspecialchars(json_encode($serviceMarkers)); ?>"></div>
                <div id="search-panel">
                    <p>Find a volunteering opportunity</p>
                    <input type="text" id="addressInput" placeholder="Location or postcode"/>
                    <select id="radiusSelect" label="Radius">
                        <option value="10" selected>10 mile radius</option>
                        <option value="20">20 mile radius</option>
                        <option value="30">30 mile radius</option>
                        <option value="40">40 mile radius</option>
                        <option value="50">50 mile radius</option>
                    </select>
                    <label class="nation-wide-search" for="nationWideSearch"><input type='checkbox' id='nationWideSearch'><span>Show all Scotland-wide opportunities.</span></label>
                    <input type="button" id="searchButton" value="Search"/>
                </div>
                
                <div class="output--nationwide hidden">
                    <?= $nationWideRoles;?>
                </div>
                <div class="output">
                    <ul>
                        <li class="no-results">Aberlour has volunteering roles across Scotland. Enter your location to find services nearest to you</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>