<?php

while (have_posts()) : the_post();

    $terms = get_the_terms(get_the_id(), 'service_category');
    $currentPageID = get_the_id();

    get_template_part('templates/page', 'header'); ?>
    <article <?php post_class(); ?>>
        <div class="entry-content">
            <div class="container">
                <div class="col-sm-8 desktop-padding">
                    <?php if($terms) { ?>
                        <ul class="service-theme-list">
                            <li>Return to service theme: </li>
                            <?php foreach($terms as $term){ ?>
                                <li><a href="<?= get_term_link($term->term_id); ?>"><?= $term->name; ?></a></li>
                            <?php } ?>
                        </ul>
                    <?php } ?>
                    <h1>Overview</h1>
                    <?php the_content(); ?>
                </div>
                <div class="col-sm-4">
                    <div class="service-sidebar">
                        <?php

                        foreach($terms as $term){
                            $name = $term->name;
                            $id = $term->term_id;
                            $pages = get_posts(array(
                                'post_type' => 'services',
                                'numberposts' => -1,
                                'exclude' => $currentPageID,
                                'tax_query' => array(
                                    array(
                                        'taxonomy' => 'service_category',
                                        'field' => 'id',
                                        'terms' => $id,
                                    )
                                )
                            ));

                            $color = get_field('category_colour', 'term_' . $id);

                            echo '<h2>'.$term->name.'</h2>';
                            echo '<ul>';
                            foreach($pages as $page){

                                echo '<li><a href="'. get_permalink($page->ID) . '">' . $page->post_title . '</a></li>';
                            }
                            echo '</ul>';
                        }
                        ?>

                    </div>
                </div>
            </div>
            <?php get_template_part('templates/services/contact-details') ?>
            <?php get_template_part('templates/services/need-help-contacts') ?>
        </div>
        <footer>
            <?php wp_link_pages(['before' => '<nav class="page-nav"><p>' . __('Pages:', 'sage'), 'after' => '</p></nav>']); ?>
        </footer>
        <?php comments_template('/templates/comments.php'); ?>
    </article>
<?php endwhile; ?>
