<?php
$title = get_sub_field('title');
$description = get_sub_field('description');
$image = get_sub_field('image');
$imgOnRight = get_sub_field('image_on_the_right');
$ctaText = get_sub_field('cta_text');
$ctaLink = get_sub_field('cta_link');
$bgColor = get_sub_field('greywhite_background_swich') ? "#F3F3F3" : "#FFF";

?>
<div style="background-color: <?= $bgColor; ?>;">
    <div class="container">
        <div class="row panel--content">
            <h2 class='col-xs-12 title'><?= $title; ?></h2>
            <div class="col-xs-12 col-lg-6 image-panel  order-<?= $imgOnRight ? '3' : '1';?>">
                <img src="<?= $image['url']; ?>">
            </div>
            <div class="col-xs-12 col-lg-6 content-panel order-2">
                <div class="description"><?= $description; ?></div>
                <?php if($ctaText && $ctaLink) { ?><a class="btn" href="<?= $ctaLink; ?>"><?= $ctaText; ?></a><?php } ?>
            </div>
        </div>
    </div>
</div>
