<?php
$terms = get_terms(array(
    "taxonomy" => "service_category",
    "exclude" => get_queried_object()->term_id
        ));
?>
<div class="intro-row container">
    <div class="row">
        <div class="col-sm-8 desktop-padding">
            <a href="/services/"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back to services</a>
            <h2>Overview</h2>
            <?php echo term_description(); ?>
        </div>
        <div class="wrapperDesktop">
            <div class="side-bar col-sm-4">
                <?php if ($terms) { ?>
                <h3>Other Services</h3>
                    <ul class="services-list">
                        <?php
                        foreach ($terms as $term) {
                            $cat_colour = get_field('category_colour', 'service_category_'.$term->term_id);
                            $url = get_term_link($term->term_id, "service_category");
                            ?>
                        <li class="purple"> <a href="<?php echo $url; ?>"> <?php echo $term->name; ?> </a> </li>
                        <?php } ?>
                    </ul>
                <?php } ?>
            </div>
        </div>
    </div>
</div>
