<article class="excerpt">
    <header>
        <h2 class="entry-title"><?php the_title(); ?></h2>
        <?php
        if (is_home()) {
            get_template_part('templates/entry-meta');
        }
        ?>
    </header>
    <div class="entry-summary col-md-8">
        <?php the_content(); ?>
        <?php
        $post_id = get_the_ID();
        $file = get_field('pdf', $post_id);

        $pageLink = get_field('page_link');
        $pageLinkTarget = get_field('page_link_target');
        if ($pageLinkTarget == 1) {
            $pageLinkTarget = "target='_blank'";
        } else {
            $pageLinkTarget = '';
        }
        if ($file || $pageLink) {
            ?>
            <div class="download-buttons">
                <?php if ($pageLink) { ?>
                    <a href="<?php the_field('page_link'); ?>" <?php echo $pageLinkTarget; ?>>view</a>
                    <a href="<?php echo $file; ?>" <?php echo $pageLinkTarget; ?>>download</a>
                <?php } elseif ($file) { ?>
                    <a onClick="ga('send', 'event', 'pubViews', 'Click', '<?php the_title(); ?>', '0');" target="_blank" href="<?php echo $file; ?>">view</a>
                <?php } ?>
            </div>
        <?php } ?>
    </div>
    <div class="col-md-4">
        <?php
        if (has_post_thumbnail()) {
            the_post_thumbnail('news thumbnail', array('class' => 'img-responsive'));
            // echo '<img class="img-responsive" src="http://placehold.it/320x240" alt="" />';
        } else {
            echo '<img class="img-responsive" src="https://d1ssu070pg2v9i.cloudfront.net/pex/aberlour/2017/03/21141848/Aberlour_master_colour_icon_article_detail_small.png" alt="" />';
        }
        ?>
    </div>
</article>
