<?php
/**
 * Template Name: FAQ Accordion Template
 */
?>

<?php while (have_posts()) : the_post(); ?>
    <?php get_template_part('templates/page', 'header'); ?>
    <div class="container faq-section">

        <div class="panel-group" id="accordion">

            <div class="faq-content">
                <?php the_content(); ?>
            </div>

            <?php
            // check if the repeater field has rows of data
            if( have_rows('faqs') ):

                $count = 0;

                // loop through the rows of data
                while ( have_rows('faqs') ) : the_row(); $count++;?>

                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <h4 class="panel-title">
                                <a data-toggle="collapse" data-parent="#accordion" href="#collapse<?php echo $count ?>">
                                    <?php the_sub_field('faq_question') ?>
                                </a>
                            </h4>
                        </div>
                        <div id="collapse<?php echo $count ?>" class="panel-collapse collapse <?php if($count == 1): echo 'in'; endif; ?>">
                            <div class="panel-body">
                                <?php the_sub_field('faq_answer'); ?>
                            </div>
                        </div>
                    </div>

                <?php endwhile; endif;
            ?>
        </div>

    </div>
    <?php get_template_part('templates/page', 'footer'); ?>
<?php endwhile; ?>