<?php
$posts = get_field('add_contact_for_service');

if ($posts) {
    ?>
    <section class="services-carousel">
        <div class="container">
            <h2>Fostering Services Contacts</h2>
            <div class="row">
                <div class="flexslider carousel">
                    <ul class="slides">
                        <?php foreach ($posts as $post) { ?>
                            <?php setup_postdata($post); 
                            
                            $featImage = wp_get_attachment_image_src(get_post_thumbnail_id(), "full") ? wp_get_attachment_image_src(get_post_thumbnail_id(), "full") : array("https://dummyimage.com/300x300/cccccc/000000.jpg&text=Pending+");
                            ?>
                            <li>
                                <div class="circled">
                                    <a href="<?php the_permalink(); ?>" class="cover-link"> </a>
                                    <div class="<?php echo $cat_colour; ?>-text">
                                        <div class="img-circle">
                                            <img class="img-circle img-responsive" src="<?php echo $featImage[0]; ?>">
                                        </div>
                                        <h2 class="h2sub-serv"><?php the_title(); ?></h2>
                                        <p><?php echo wp_trim_words(get_the_content(), 10, '..'); ?></p>
                                    </div>
                                </div>
                            </li>
                            <?php } ?>
                    </ul>
                </div>
            </div>
        </div>
    </section>
<?php } ?>

