<?php

while (have_posts()) : the_post();

    $terms = get_the_terms(get_the_id(), 'service_category');
    $currentPageID = get_the_id();
    
    get_template_part('templates/page', 'header'); ?>
    <article <?php post_class(); ?>>
        <div class="entry-content">
            <div class="container">
                <div class="col-sm-8 desktop-padding">
                    <?php if($terms) { ?>
                        <ul class="service-theme-list">
                            <li>Return to service theme: </li>
                            <?php foreach($terms as $term){ ?>
                                <li><a href="<?= get_term_link($term->term_id); ?>"><?= $term->name; ?></a></li>
                            <?php } ?>
                        </ul>
                    <?php } ?>
                    <?php the_content(); ?>
                    <?php
                        if (get_field('object_embed')){
                            echo '<div class="embed-container">';
                            the_field('object_embed');
                            echo '</div>';
                        }
                    ?>
                </div>
                <div class="col-sm-4">
                    <?php 
                        if ( has_post_thumbnail() ) {
                            $thumb = get_the_post_thumbnail_url($currentPageID,'large');
                        ?>
                        <img class="img-responsive" src="<?=$thumb;?>" alt="<?php the_title();?>"/>
                        <?php
                        } 
                    ?>
                    <div class="column-content">
                        <?php the_field('column_content'); ?>
                    </div>
                    <?php if( have_rows('testimonials') ): ?>
                	<?php while( have_rows('testimonials') ): the_row(); 
                		$pullQuote = get_sub_field('blockquote');
                        $pullQuoteCite = get_sub_field('citation');
                
                        if($pullQuote){
                        ?>
                    <blockquote class="blockquote">
                        <span class="quote color-green">“</span>
                        <p><?=$pullQuote;?></p>
                        <span class="quote color-green">”</span>
                        <?php 
                            if ($pullQuoteCite){
                            ?>
                            <p class="cite color-green">
                                <i class="fa fa-angle-right"></i> 
                                <?= $pullQuoteCite; ?>
                            </p>
                        <?php 
                            }
                        ?>
                    </blockquote>
                    <?php 
                        }
                    ?>
            	<?php endwhile; ?>

                <?php endif; ?>
                
                </div>
            </div>
        <?php get_template_part('templates/services/contact-details') ?>
        <?php get_template_part('templates/services/need-help-contacts') ?>
        </div>
        <footer>
            <?php wp_link_pages(['before' => '<nav class="page-nav"><p>' . __('Pages:', 'sage'), 'after' => '</p></nav>']); ?>
        </footer>
        <?php comments_template('/templates/comments.php'); ?>
    </article>
<?php endwhile; ?>
