<?php

namespace Roots\Sage\Setup;

use Roots\Sage\Assets;

/**
 * Theme setup
 */
function setup() {
  // Enable features from Soil when plugin is activated
  // https://roots.io/plugins/soil/
  add_theme_support('soil-clean-up');
  add_theme_support('soil-nav-walker');
  add_theme_support('soil-nice-search');
  add_theme_support('soil-jquery-cdn');
  add_theme_support('soil-relative-urls');

  // Make theme available for translation
  // Community translations can be found at https://github.com/roots/sage-translations
  load_theme_textdomain('sage', get_template_directory() . '/lang');

  // Enable plugins to manage the document title
  // http://codex.wordpress.org/Function_Reference/add_theme_support#Title_Tag
  add_theme_support('title-tag');

  // Register wp_nav_menu() menus
  // http://codex.wordpress.org/Function_Reference/register_nav_menus
  register_nav_menus([
    'primary_navigation' => __('Primary Navigation', 'sage'),
    'New Navigation' => __('New Navigation', 'sage'),
    'Footer Documentation Navigation' => __('Footer Documentation Navigation', 'sage'),
  ]);

  // Enable post thumbnails
  // http://codex.wordpress.org/Post_Thumbnails
  // http://codex.wordpress.org/Function_Reference/set_post_thumbnail_size
  // http://codex.wordpress.org/Function_Reference/add_image_size
  add_theme_support('post-thumbnails');

  add_image_size('news thumbnail', 320, 240, true);
  add_image_size('the-people', 250, 250, true);
  add_image_size('square-col-xs', 500, 500, true);
  // Enable post formats
  // http://codex.wordpress.org/Post_Formats
  add_theme_support('post-formats', ['aside', 'gallery', 'link', 'image', 'quote', 'video', 'audio']);

  // Enable HTML5 markup support
  // http://codex.wordpress.org/Function_Reference/add_theme_support#HTML5
  add_theme_support('html5', ['caption', 'comment-form', 'comment-list', 'gallery', 'search-form']);

  // Use main stylesheet for visual editor
  // To add custom styles edit /assets/styles/layouts/_tinymce.scss
  add_editor_style(Assets\asset_path('styles/main.css'));
}
add_action('after_setup_theme', __NAMESPACE__ . '\\setup');

// Adding excerpt for page
add_post_type_support( 'page', 'excerpt' );

/**
 * Register sidebars
 */
function widgets_init() {
  register_sidebar([
    'name'          => __('Primary', 'sage'),
    'id'            => 'sidebar-primary',
    'before_widget' => '<section class="widget %1$s %2$s">',
    'after_widget'  => '</section>',
    'before_title'  => '<h3>',
    'after_title'   => '</h3>'
  ]);

  register_sidebar([
    'name'          => __('Footer', 'sage'),
    'id'            => 'sidebar-footer',
    'before_widget' => '<section class="widget %1$s %2$s">',
    'after_widget'  => '</section>',
    'before_title'  => '<h3>',
    'after_title'   => '</h3>'
  ]);
}
add_action('widgets_init', __NAMESPACE__ . '\\widgets_init');

/**
 * Determine which pages should NOT display the sidebar
 */
function display_sidebar() {
  static $display;

  isset($display) || $display = !in_array(true, [
    // The sidebar will NOT be displayed if ANY of the following return true.
    // @link https://codex.wordpress.org/Conditional_Tags
    is_404(),
    is_front_page(),
    is_post_type_archive( 'services' ),
    is_post_type_archive( 'volunteering' ),
    is_post_type_archive( 'people' ),
    is_post_type_archive( 'stories' ),
    is_tax('position'),
    is_tax( 'service_category' ),
    is_singular('services'),
    is_singular('volunteering'),
    is_singular('stories'),
    is_singular('events'),
    is_singular('people'),
    is_page(),
    is_page_template('template-services.php'),
    is_page_template('template-needhelp.php'),
    is_page_template('template-helpus.php')
  ]);

  return apply_filters('sage/display_sidebar', $display);
}

/**
 * Theme assets
 */
function assets() {
  wp_enqueue_style('sage/css2', Assets\asset_path('styles/main-blessed2.css'), false, null);
  wp_enqueue_style('sage/css1', Assets\asset_path('styles/main-blessed1.css'), false, null);
  wp_enqueue_style('sage/css', Assets\asset_path('styles/main.css'), false, null);

  if (is_single() && comments_open() && get_option('thread_comments')) {
    wp_enqueue_script('comment-reply');
  }

  if(is_post_type_archive('services') || is_post_type_archive('volunteering') || is_page_template('template-volunteering.php') || is_page_template('template-volunteering-new.php')){
      wp_enqueue_script('ajax/maps/spherical', "//maps.googleapis.com/maps/api/js?key=AIzaSyAGsKZ5PP8iURMpB4kRQKcpLQps-szGeqw&libraries=geometry&region=GB");
      wp_enqueue_script( 'postcode-searcher', get_template_directory_uri() . '/assets/scripts/postcode-searcher.js', array('jquery'), null, true);
  }


  wp_enqueue_script('sage/js', Assets\asset_path('scripts/main.js'), ['jquery'], null, true);
}
add_action('wp_enqueue_scripts', __NAMESPACE__ . '\\assets', 100);
