<?php

get_template_part('templates/home/home-header'); ?>
<h2 class="homepage">Our vision is that every child in Scotland has the chance to flourish. With your help,
    we will reach more children and their families earlier, before damage is done, before
    families reach crisis point, before it’s too late.</h2>
<?php get_template_part('templates/global/new-service-block');

$cta1 = get_field('split_box_cta_1');
$cta2 = get_field('split_box_cta_2');
?>

<section class="fluid-bg-container banner-links-support">
    <div class="container-fluid">
        <div class="col-xs-12 col-md-6 green-bg fluid-bg-colour-left support-panel ">
            <h2><?php the_field('split_box_title_1') ?></h2>
            <?php the_field('split_box_content_1') ?>
            <a class="general-button" href="<?= $cta1['url'] ?>"><?= $cta1['title']; ?></a>
        </div>
        <div class="col-xs-12 col-md-6 fluid-bg-colour-right front-block support-panel ">
            <h2><?php the_field('split_box_title_2') ?></h2>
            <?php the_field('split_box_content_2') ?>
            <a class="general-button" href="<?= $cta2['url'] ?>"><?= $cta2['title']; ?></a>
        </div>
    </div>
</section>

<?php query_posts( array(
    'posts_per_page' => 3,
)); ?>

<div class="news-block">
    <div class="container">

        <h2>News</h2>

        <div class="row row-eq-height">
            <?php if( have_posts() ){
                while ( have_posts() ) {
                    the_post(); ?>
                    <div class="col-xs-12 col-lg-4 post-col">
                        <div class="custom-post-item">
                            <p><?= get_the_date(); ?></p>
                            <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                            <div class="post-cta">
                                <a href="<?php the_permalink(); ?>">Read More</a>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            <?php } ?>
        </div>

        <div class="main-cta">
            <a href="/news/">View All</a>
        </div>

    </div>
</div>
