<?php
/**
 * Sage includes
 *
 * The $sage_includes array determines the code library included in your theme.
 * Add or remove files to the array as needed. Supports child theme overrides.
 *
 * Please note that missing files will produce a fatal error.
 *
 * @link https://github.com/roots/sage/pull/1042
 */
$sage_includes = [
  'lib/assets.php',    // Scripts and stylesheets
  'lib/extras.php',    // Custom functions
  'lib/setup.php',     // Theme setup
  'lib/titles.php',    // Page titles
  'lib/wrapper.php',   // Theme wrapper class
  'lib/customizer.php' // Theme customizer
];

foreach ($sage_includes as $file) {
  if (!$filepath = locate_template($file)) {
    trigger_error(sprintf(__('Error locating %s for inclusion', 'sage'), $file), E_USER_ERROR);
  }

  require_once $filepath;
}
unset($file, $filepath);

function kriesi_pagination($pages = '', $range = 2)
{
    $showitems = ($range * 2)+1;

    global $paged;
    if(empty($paged)) $paged = 1;

    if($pages == '')
    {
        global $wp_query;
        $pages = $wp_query->max_num_pages;
        if(!$pages)
        {
            $pages = 1;
        }
    }

    if(1 != $pages)
    {
        echo "<div class='pagination'>";
        if($paged > 2 && $paged > $range+1 && $showitems < $pages) echo "<a href='".get_pagenum_link(1)."'>&laquo;</a>";
        if($paged > 1 && $showitems < $pages) echo "<a href='".get_pagenum_link($paged - 1)."'>&lsaquo;</a>";

        for ($i=1; $i <= $pages; $i++)
        {
            if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems ))
            {
                echo ($paged == $i)? "<span class='current'>".$i."</span>":"<a href='".get_pagenum_link($i)."' class='inactive' >".$i."</a>";
            }
        }

        if ($paged < $pages && $showitems < $pages) echo "<a href='".get_pagenum_link($paged + 1)."'>&rsaquo;</a>";
        if ($paged < $pages-1 &&  $paged+$range-1 < $pages && $showitems < $pages) echo "<a href='".get_pagenum_link($pages)."'>&raquo;</a>";
        echo "</div>\n";
    }
}

add_action( 'after_setup_theme', 'wpdocs_theme_setup' );
function wpdocs_theme_setup() {
    add_image_size( 'custom-thumb', '250' ); 
    add_image_size( 'square-thumb', 250, 250, TRUE);
    add_image_size('campaign-image', 356, 250, true);

}

function add_people_filter( $query ) {
    if( !is_admin() && $query->is_category('position') && $query->is_main_query ) {
        $query->set( 'post_type', array(
            'post', 'people'
));
    }
}
add_filter( 'pre_get_posts', 'add_people_filter' );

function people_pre_get_posts( $query ) {
        if( is_admin() ) {
            return $query;
        }
        if( isset($query->query_vars['post_type']) && $query->query_vars['post_type'] == 'people' ) {
            $query->set('orderby', 'meta_value_num');   
            $query->set('meta_key', 'order');   
            $query->set('order', 'ASC'); 
        }
        return $query;
    }
    add_action('pre_get_posts', 'people_pre_get_posts');
    
add_action('do_meta_boxes', 'replace_featured_image_box');  
function replace_featured_image_box()  
{  
    remove_meta_box( 'postimagediv', array('post', 'page', 'stories', 'events', 'publications', 'people'), 'side' );  
    add_meta_box('postimagediv', __('Featured Image (recommended size: 300px x 300px)'), 'post_thumbnail_meta_box', array('post', 'page', 'stories', 'events', 'publications', 'people'), 'side', 'low');  
}

// Change the add to cart button INTO View Product button
// =================================================================================================================

add_filter( 'woocommerce_loop_add_to_cart_link', 'add_product_link' );
function add_product_link( $link ) {
global $product;
    echo '<form class="shop-button" action="' . esc_url( $product->get_permalink( $product->get_id() ) ) . '" method="get">
            <button type="submit" class="button add_to_cart_button product_type_simple">' . __('View Product', 'woocommerce') . '</button>
          </form>';
}
/**
 * Ensure cart contents update when products are added to the cart via AJAX
 */
function my_header_add_to_cart_fragment( $fragments ) {
 
    ob_start();
    $count = WC()->cart->cart_contents_count;
    if ( $count > 0 ) {
    ?><a class="cart-contents" href="<?php echo WC()->cart->get_cart_url(); ?>" title="<?php _e( 'View your shopping cart' ); ?>"><?php
    
        ?>
        <span class="cart-contents-count"><?php echo esc_html( $count ); ?></span>
        <?php            
   
        ?></a><?php
 
    $fragments['a.cart-contents'] = ob_get_clean();
     
    return $fragments;
    }
}
add_filter( 'woocommerce_add_to_cart_fragments', 'my_header_add_to_cart_fragment' );

add_action( 'admin_init', 'remove_menu_items' );
function remove_menu_items() {

    global $user_ID;

    if ( current_user_can( 'it-team' ) ) {
		remove_menu_page( 'edit.php' );
		remove_menu_page( 'admin.php?page=wpcf7' );
		remove_menu_page( 'admin.php?page=acf-options-theme-settings' );
		remove_menu_page( 'tools.php');
    }
}


add_filter( 'ninja_forms_admin_parent_menu_capabilities',   'nf_subs_capabilities' ); // Parent Menu
add_filter( 'ninja_forms_admin_all_forms_capabilities',     'nf_subs_capabilities' ); // Forms Submenu
add_filter( 'ninja_forms_admin_submissions_capabilities',   'nf_subs_capabilities' ); // Submissions Submenu
function nf_subs_capabilities( $cap ) {
    return 'edit_posts'; // EDIT: User Capability
}

add_action('wp_enqueue_scripts', 'localizeScripts', 101);
function localizeScripts(){
    ?>
    <script type="text/javascript">
        const ajax_url = <?php echo json_encode( admin_url( "admin-ajax.php" ) ); ?>; 
    </script>
    <?php
}

add_action('wp_ajax_loadMoreComments','loadMoreComments');
add_action('wp_ajax_nopriv_loadMoreComments', 'loadMoreComments');

function loadMoreComments()
{
    $currentOffset = $_POST['currentOffset'] * 10;
    $pageId = $_POST['pageId'];

    if(have_rows("panels", $pageId)){
        while(have_rows("panels", $pageId)){
            the_row();
            if (get_row_layout() == "comments_panel"){
                $commentsRows = get_sub_field('comments');
                if(!$commentsRows || count($currentOffset) < $currentOffset) break;

                for($i = 0; $i < 10 && count($commentsRows) > $currentOffset + $i; $i++){
                        $commentText = $commentsRows[$currentOffset + $i]['comment_text'];?>
                        <div class="comment-block">
                            <div class="comment col-xs-12 col-lg-6"><?=$commentText?></div>
                        </div>
                <?php
                }
            }
        }
    }
    wp_reset_postdata();
    wp_die();
}