<?php while (have_posts()) : the_post(); ?>
    <article <?php post_class(); ?>>
        <div class="entry-content container">
            <div class="row">
                <div class="col-md-8 desktop-padding">
                    <?php the_content(); ?>
                    <hr>
                    <?php
                        if( have_rows('content_block') ):
                            while ( have_rows('content_block') ) : the_row();
                                if( get_row_layout() == 'story_block' ): ?>
                                    <div class="row story-block">
                                        <div class="col-md-8 story-text">
                                            <?php the_sub_field('content'); ?>   
                                        </div>
                                        <div class="col-md-4"?>
                                            <img src="<?php the_sub_field('image'); ?>">
                                        </div>
                                    </div>
                                <?php endif;
                            endwhile;
                        endif;
                        ?>
                </div>
                
                <div class="col-md-4">
                        <?php
                        $posts = get_field('related_services');
                        if( $posts ): ?>
                            <ul>
                            <h2>Related Services</h2>
                            <?php foreach( $posts as $post): ?>
                                <?php setup_postdata($post); ?>
                                <a href="<?php the_permalink(); ?>" class="cover-link" title="<?php the_title(); ?>"> </a>
                                <p class="lead"><?php the_title(); ?></p>
                                <?php echo get_the_post_thumbnail( $post, 'large', array( 'class' => 'img-responsive')); ?>
                                <p><a class="cta" href="<?php the_permalink(); ?>">Find out more</a></p>
                                <hr>
                            <?php endforeach; ?>
                            </ul>
                            <?php wp_reset_postdata(); ?>
                        <?php endif; ?>
                </div>
            </div>
        </div>
    </article>
<?php endwhile; ?>
