<?php
$posts = get_field('stories');

if ($posts) {
    ?>
    <section class="services-carousel">
        <div class="container">
            <h1>Our stories</h1>
            <div class="row">
                <div class="flexslider carousel">
                    <ul class="slides">
                        <?php foreach ($posts as $post) { ?>
                            <?php setup_postdata($post); 
                            $featImage = wp_get_attachment_image_src(get_post_thumbnail_id(), "square-thumb") ? wp_get_attachment_image_src(get_post_thumbnail_id(), "square-thumb") : array("/content/themes/aberlour/assets/images/a-logo.png");
                            ?>
                            <li>
                                <div class="circled">
                                    <a href="<?php the_permalink(); ?>" class="cover-link"> </a>
                                        <div class="img-circle">
                                            <img class="img-circle img-responsive" src="<?php echo $featImage[0]; ?>">
                                        </div>
                                        <h2 class="h2sub-serv"><?php the_title(); ?></h2>
                                        <p><?php echo wp_trim_words(get_the_content(), 10, '..'); ?></p>
                                </div>
                            </li>
                            <?php } ?>
                    </ul>
                </div>
            </div>
        </div>
    </section>
<?php } ?>
<?php wp_reset_postdata(); ?>


