<?php 
$title = get_sub_field('title');

$bgColor = get_sub_field('background_color') ? "#F3F3F3" : "#FFF";
$cardsPerRow = get_sub_field('cards_per_row');
$cardClass="6";
switch($cardsPerRow){
    case "2":
        $cardClass = "6";
        break;
    case "3":
        $cardClass = "4";
        break;
    case "4":
        $cardClass = "3";
        break;
    default: 
        $cardClass = "6";
        break;

}
?>
<div style="background-color: <?= $bgColor; ?>;">
    <div class="container">
        <div class="row panel--cards">
            <h2 class="col-xs-12"><?= $title; ?></h2>
            <?php if(have_rows('cards')){
                while(have_rows('cards')){
                    the_row();
                    $title = get_sub_field('title');
                    $text = get_sub_field('text');
                    $ctaText = get_sub_field('cta_text');
                    $ctaLink = get_sub_field('cta_link');
                    ?>
                    <div class="col-xs-12 col-lg-<?= $cardClass; ?> card-box">
                        <div class="inner-wrapper">
                            <h3><?= $title; ?></h3>
                            <div class="description"><?= $text; ?></div>
                            <a href="<?= $ctaLink;?>"><?= $ctaText; ?></a>
                        </div>
                    </div>
            <?php }
            } ?>
        </div>
    </div>
</div>