<?php
/**
 * Template Name: Get Involved Template
 */
?>

<?php while (have_posts()) : the_post(); ?>
    <?php get_template_part('templates/page', 'header'); ?>
    <div class="container help-blocks">
        <?php if (have_rows('how_you_can_help_blocks')) { ?>
            <h2><?php the_field('help_block_title'); ?></h2>
            <div class="row">
                <?php while (have_rows('how_you_can_help_blocks')) {
                    the_row();
                    ?>
                    <div class="col-xs-6 col-md-4 col-lg-3 block-col">
                        <div class="inner-help-block" style="background-image:url('<?php the_sub_field('image'); ?>')">
                            <a href="<?php the_sub_field('link'); ?>">
                                <h3>
                                    <?php the_sub_field('title'); ?>
                                </h3>
                            </a>
                        </div>
                    </div>
                <?php } ?>
            </div>
        <?php } ?>
    </div>

    <?php
    $cta1 = get_field('box_cta_1');
    $cta2 = get_field('box_cta_2');
    ?>

    <section class="fluid-bg-container banner-links-support">
        <div class="container-fluid">
            <div class="col-xs-12 col-md-6 green-bg fluid-bg-colour-left support-panel ">
                <h2><?php the_field('box_title_1') ?></h2>
                <?php the_field('box_content_1') ?>
                <a class="general-button" href="<?= $cta1['url'] ?>"><?= $cta1['title']; ?></a>
            </div>
            <div class="col-xs-12 col-md-6 fluid-bg-colour-right front-block support-panel ">
                <h2><?php the_field('box_title_2') ?></h2>
                <?php the_field('box_content_2') ?>
                <a class="general-button" href="<?= $cta2['url'] ?>"><?= $cta2['title']; ?></a>
            </div>
        </div>
    </section>
<?php endwhile; ?>
