/* ========================================================================
 * DOM-based Routing
 * Based on http://goo.gl/EUTi53 by Paul Irish
 *
 * Only fires on body classes that match. If a body class contains a dash,
 * replace the dash with an underscore when adding it to the object below.
 *
 * .noConflict()
 * The routing is enclosed within an anonymous function so that you can
 * always reference jQuery with $, even when in .noConflict() mode.
 * ======================================================================== */

(function ($) {

    // Breakpoints to match Bootstrap.
    var screenXsMin = 480,
        screenSmMin = 768,
        screenMdMin = 990,
        screenLgMin = 1200,
        screenXlMin = 1500;


    // tiny helper function to add breakpoints
    function getGridSize() {
        return (window.innerWidth < 480) ? 1 :
            (window.innerWidth < 768) ? 2 :
                (window.innerWidth < 990) ? 3 : 5;
    }

    // Use this variable to set up the common and page specific functions. If you
    // rename this variable, you will also need to rename the namespace below.
    var Sage = {
        // All pages
        'common': {
            init: function () {

                $('.nav-toggle').on('click', function () {
                    $('.menu-col').slideToggle();
                });

                $('.people .box').matchHeight();

                $('.dropdown--update-text .dropdown-menu li>a').on('click', function () {
                    var ddToggler = $(this).parent().parent().parent().find('.dropdown-toggle'),
                        newTogglerVal = $(this).text();

                    ddToggler.text(newTogglerVal);
                });

                if ($('.multi-section-container').length > 0) {
                    var currentSection = '#section-0000',
                        prevSection = currentSection,
                        sectionTop = '#' + $('.multi-section-container > a:first-child').attr('id');//'#decade-1913';
                    $(window).on('scroll', function () {

                        // monitor anchors.
                        $('a[id*="section-id_"]').each(function () {
                            sectionTop = $(this).offset().top - $(window).scrollTop();
                            if (sectionTop < 80) {
                                currentSection = '#' + $(this).attr('id');
                            }
                        });
                        if (prevSection !== currentSection) {
                            prevSection = currentSection;
                            $('.dropdown--update-text>a').text($(currentSection).next('.section').find('h2').text());

                        }
                    });
                }

                function revealOnScroll() {
                    var scrolled = $(window).scrollTop();

                    $('.scrollToggle').each(function () {
                        const offsetTop = $(this).offset().top;

                        if (scrolled + ($(window).height() * 0.9) > offsetTop) {
                            $(this).addClass('scrollToggle--in');
                        } else {
                            $(this).removeClass('scrollToggle--in');
                        }
                    });
                }
                $(window).on('scroll resize', revealOnScroll);
                revealOnScroll();

                //Checking if iframe is on service single page
                if ($('.tax-service_category iframe').length > 0) {
                    $('.services-listing').addClass('active-frame');
                }

                //Checking for Mobile Width
                var $window = $(window);
                var $pane = $('body');

                function checkWidth() {
                    var windowsize = $window.width();
                    if (windowsize < 993) {
                        $('.menu-col').addClass('mobileNav');
                    } else {
                        $('.menu-col').removeClass('mobileNav');
                    }
                }
                checkWidth();
                $(window).resize(checkWidth);

                //Mobile Nav Opening
                $('.mobileNav .menu-item-has-children').on('click', function () {
                    $(this).find('.sub-menu').slideToggle();
                });

                $('a[href^="//donations.aberlour.org.uk"], a[href^="//donations.aberlour.org.uk/page.aspx?pid=298#.WRxCo2grKUk"]').click(function () {
                    //console.log(this);
                    ga("send", {
                        hitType: 'event',
                        eventCategory: 'donateClick',
                        eventAction: $(this).attr('href'),
                        page: window.location.toString()
                    });
                });
                $('a[href^="//workwithus.aberlour.org.uk"], a[href^="//workwithus.aberlour.org.uk/tlive_webrecruitment/wrd/run/etrec106gf.display_srch_all?wvid=82658500X0"] ').click(function () {
                    //console.log(this);
                    ga("send", {
                        hitType: 'event',
                        eventCategory: 'workWithUsClick',
                        eventAction: $(this).attr('href'),
                        page: window.location.toString()
                    });
                });

                // JavaScript to be fired on all pages

                // Madernizr can occationally return a false negative for csstransforms3d in Chrome, so we need to browser sniff.
                /* var isChrome = /Chrome/.test(navigator.userAgent) && /Google Inc/.test(navigator.vendor);
                 if (isChrome === true) {
                     $('html').removeClass('no-csstransforms3d').addClass('csstransforms3d');
                 }*/

                /*
                *  add_marker
                *
                *  This function will add a marker to the selected Google Map
                *
                *  @type	function
                *  @date	8/11/2013
                *  @since	4.3.0
                *
                *  @param	$marker (jQuery element)
                *  @param	map (Google Map object)
                *  @return	n/a
                */

                function add_marker($marker, map) {

                    // var
                    var latlng = new google.maps.LatLng($marker.attr('data-lat'), $marker.attr('data-lng'));

                    // create marker
                    var marker = new google.maps.Marker({
                        position: latlng,
                        map: map
                    });

                    // add to array
                    map.markers.push(marker);

                    // if marker contains HTML, add it to an infoWindow
                    if ($marker.html()) {
                        // create info window
                        var infowindow = new google.maps.InfoWindow({
                            content: $marker.html()
                        });

                        // show info window when marker is clicked
                        google.maps.event.addListener(marker, 'click', function () {

                            infowindow.open(map, marker);

                        });
                    }

                }

                /*
                *  center_map
                *
                *  This function will center the map, showing all markers attached to this map
                *
                *  @type	function
                *  @date	8/11/2013
                *  @since	4.3.0
                *
                *  @param	map (Google Map object)
                *  @return	n/a
                */

                function center_map(map) {

                    // vars
                    var bounds = new google.maps.LatLngBounds();

                    // loop through all markers and create bounds
                    $.each(map.markers, function (i, marker) {

                        var latlng = new google.maps.LatLng(marker.position.lat(), marker.position.lng());

                        bounds.extend(latlng);

                    });

                    // only 1 marker?
                    if (map.markers.length === 1) {
                        // set center of map
                        map.setCenter(bounds.getCenter());
                        map.setZoom(16);
                    }
                    else {
                        // fit to bounds
                        map.fitBounds(bounds);
                    }

                }


                /*
*  new_map
*
*  This function will render a Google Map onto the selected jQuery element
*
*  @type	function
*  @date	8/11/2013
*  @since	4.3.0
*
*  @param	$el (jQuery element)
*  @return	n/a
*/

                function new_map($el) {

                    // var
                    var $markers = $el.find('.marker');


                    // vars
                    var args = {
                        zoom: 16,
                        center: new google.maps.LatLng(0, 0),
                        mapTypeId: google.maps.MapTypeId.ROADMAP
                    };


                    // create map
                    var map = new google.maps.Map($el[0], args);


                    // add a markers reference
                    map.markers = [];


                    // add markers
                    $markers.each(function () {

                        add_marker($(this), map);

                    });


                    // center map
                    center_map(map);


                    // return
                    return map;

                }

                /*
                *  document ready
                *
                *  This function will render each map when the document is ready (page has loaded)
                *
                *  @type	function
                *  @date	8/11/2013
                *  @since	5.0.0
                *
                *  @param	n/a
                *  @return	n/a
                */
                // global var
                var map = null;

                $(document).ready(function () {

                    $('.acf-map').each(function () {

                        // create map
                        map = new_map($(this));

                    });

                });


                setTimeout(function () {
                    $('.map-container.acf-map').attr('style', ''); // Remove inline styles from homepage map div.

                }, 500);


                $('.quick-links-toggle').click(function () {
                    $(this).toggleClass('open').next('.quick-links').toggleClass('open');
                });

                var carouselSlider;

                //new MlPushMenu(document.getElementById('mp-menu'), document.getElementById('trigger'));

                $('.mp-trigger').on('click', function () {
                    $('body').addClass('heightLimiter');
                });
                $('#mp-pusher').on('click', function () {
                    $('body').removeClass('heightLimiter');
                });


                $(".closeTab").click(function () {
                    $('#mp-pusher').trigger('click');
                    $(".closeTab > i").addClass("spinners");
                    setTimeout(function () {
                        $('.closeTab > i').removeClass('spinners');
                    }, 1000);
                });

                $('.flexslider').flexslider({
                    animation: "slide",
                    animationLoop: true,
                    itemWidth: 210,
                    itemMargin: 5,
                    minItems: getGridSize(),
                    maxItems: getGridSize()
                });


                // Smooth scroll to target
                var scrollToTarget = function (tgtEl, siteHeader, scrollSpeed, additionalOffset) {
                    if (scrollSpeed === undefined) {
                        scrollSpeed = 500;
                    }
                    // is header fixed?
                    hoffset = 0;
                    extraOffset = 0;
                    if (siteHeader !== undefined) {
                        if (siteHeader.css('position') === 'fixed') {
                            hoffset = siteHeader.outerHeight(true);
                        }
                    }
                    if (additionalOffset !== undefined) {
                        extraOffset = additionalOffset.outerHeight(true);
                    }
                    scrollToLoc = tgtEl.offset().top - (hoffset + extraOffset);
                    $('html, body').animate({
                        scrollTop: scrollToLoc
                    }, scrollSpeed);
                };

                $('a[href^="#"]').on('click', function (e) {
                    e.preventDefault();
                    if ($(this).attr('href').length > 1) {
                        tgtEl = $($(this).attr('href'));

                        // Detect next/prev links!
                        tgtID = $(this).attr('href');
                        if (tgtID.indexOf('#find') > -1) {
                            mySection = $(this).closest('section');
                            if (tgtID === '#findPrev') {
                                prevSection = mySection.prev('section');
                                tgtID = '#' + prevSection.attr('id');
                            } else if (tgtID === '#findNext') {
                                nextSection = mySection.next('section');
                                tgtID = '#' + nextSection.attr('id');
                            }
                            tgtEl = $(tgtID);
                        }

                        scrollSpeed = 500;
                        siteHeader = $('header.banner');
                        scrollToTarget(tgtEl, siteHeader, scrollSpeed);
                    }
                });


                // Match Heights (in a short timeout to allow any other js plugins to initialise (flexslider etc.)
                setTimeout(function () {
                    $('.people, .woocommerce li.product, .services .tabled>div, .circled h2, .matchheights').matchHeight();
                }, 200);

                // Twitter widget
                if ($('#twitterBox').length > 0) {
                    el = $('#twitterBox');
                    twitterHandle = el.attr('data-handle');
                    el.append('<div id="twitterFetcher"></div>');
                    var configProfile = {
                        "profile": { "screenName": twitterHandle },
                        "domId": 'twitterFetcher',
                        "maxTweets": 20,
                        "enableLinks": true,
                        "showUser": true,
                        "showTime": true,
                        "showImages": false,
                        "showRetweet": false,
                        "lang": 'en'
                    };
                    twitterFetcher.fetch(configProfile);

                    $('#twitterFetcher').before('<div class="twitter-header"><span>Tweets</span> by <a href="http://twitter.com/' + twitterHandle + ' target="_blank"">@' + twitterHandle + '</a></div>');
                    $('#twitterFetcher').after('<div class="twitter-footer"><a href="http://twitter.com/' + twitterHandle + '" target="_blank">View on Twitter</a></div>');
                }

                carouselSlider = $('.flexslider');

                var mailingListPlaceholder = $('#newsletter-email').attr('placeholder'),
                    smallPlaceholder = 'your email address...';


                $('.flex-section-nav a').on('click', function () {
                    // if($('.flex-section').length>0){
                    var currentSection = -150;
                    $('.flex-section.currentSection').removeClass('currentSection');
                    $('.flex-section').each(function () {
                        currentSection = $(this).offset().top - $(window).scrollTop();
                        if (currentSection > -149) {
                            $(this).addClass('currentSection');
                            return false;
                        }
                        // $(this).attr('data-offsettop',($(this).offset().top-$(window).scrollTop()));
                    });

                    if ($(this).hasClass('prev')) {
                        tgtEl = $('.flex-section.currentSection').prev('.flex-section');
                    }
                    if ($(this).hasClass('next')) {
                        tgtEl = $('.flex-section.currentSection').next('.flex-section');
                    }
                    scrollSpeed = 500;
                    siteHeader = $('header.banner');
                    scrollToTarget(tgtEl, siteHeader, scrollSpeed);
                    //     }

                });
                $(window).on('resize load', function () {
                    var winWidth = $(window).outerWidth();

                    // Left column block position swap on < sm screens
                    if (winWidth < screenSmMin) {
                        $('.wrapperDesktop>div').prependTo($('.wrapperMobile'));
                    } else {
                        $('.wrapperMobile>div').prependTo($('.wrapperDesktop'));
                    }

                    // Mailing list placeholder
                    if (winWidth < screenSmMin) {
                        $('#newsletter-email').attr('placeholder', smallPlaceholder);
                    } else if (winWidth > screenMdMin && winWidth < screenLgMin) {
                        $('#newsletter-email').attr('placeholder', smallPlaceholder);
                    } else {
                        $('#newsletter-email').attr('placeholder', mailingListPlaceholder);
                    }

                    $('.flex-section').each(function () {
                        $('.img-container, .text-container', this).removeClass('v-center').css('height', '');
                        if (winWidth > screenSmMin - 1) {
                            $('.img-container, .text-container', this).addClass('v-center').css('height', $(this).outerHeight());
                        }
                    });


                });

                $(window).resize(function () {
                    //console.log('resize');


                    var gridSize = getGridSize();
                    if (carouselSlider.length > 0) {
                        carouselSlider.data('flexslider').vars.minItems = gridSize;
                        carouselSlider.data('flexslider').vars.maxItems = gridSize;
                    }

                    //  $("#searchform").css('top','').removeClass('open');

                });

                $(window).on('load scroll', function () {
                    if ($('.dropdown-container').length > 0) {
                        offsetT = $('main.main .dropdown-container').parent().offset().top;
                        if ($(window).scrollTop() > offsetT) {
                            $('.dropdown-container').addClass('fixme').css('width', $('.dropdown-container').parent().outerWidth());
                        } else {
                            $('.dropdown-container').removeClass('fixme').css('width', '');
                        }
                        if ($(window).scrollTop() > offsetT + 150) {
                            $('.flex-section-nav').addClass('on');
                        } else {
                            $('.flex-section-nav').removeClass('on');
                        }
                    }
                });

                var acc = document.getElementsByClassName("accordion-button");
                var acci;

                for (acci = 0; acci < acc.length; acci++) {
                    acc[acci].addEventListener("click", function () {
                        this.classList.toggle("active");
                        var panel = this.nextElementSibling;
                        if (panel.style.maxHeight) {
                            panel.style.maxHeight = null;
                        } else {
                            panel.style.maxHeight = panel.scrollHeight + "px";
                        }
                    });
                }
                document.addEventListener( 'wpcf7mailsent', function( event ) {
                    $('.success-message').removeClass('hidden');
                    $('.panel--form .content-panel').addClass('hidden');
                    $('#btnCopyToClipboard').click(function() {
                        const copyLink = document.getElementById("linkToCopy");
                        copyLink.select();                      
                        document.execCommand("copy");
                    });
                }, false );
                $('#btnCopyToClipboard').click(function() {
                    const copyLink = document.getElementById("linkToCopy");
                    copyLink.focus();
                    copyLink.setSelectionRange(0, copyLink.value.length);                  
                    document.execCommand("copy");
                    const oldHtml = $('#btnCopyToClipboard').html();
                    $('#btnCopyToClipboard').html("<i class='fa fa-check'></i> Text copied");
                    setTimeout(function (){ $('#btnCopyToClipboard').html(oldHtml)}, 2000);
                });
                $('.load-more-comments').click(function(){
                    const actualOffset = $('.load-more-comments').attr('data-offset');
                    const pageId = $('.load-more-comments').attr('data-page-id');
                    $('.load-more-comments').attr('data-offset', parseInt(actualOffset)+1);
                    var successRequest = false;
                    $.ajax({
                        url: ajax_url,
                        data: {
                            action: 'loadMoreComments',
                            currentOffset: actualOffset,
                            pageId : pageId
                        },
                        type: 'POST',
                        beforeSend: function() {
                            $('.load-more-comments').html('<i class="fa fa-spinner fa-spin"></i>');
                        },
                        success: function(data) {
                            if (data) {
                                $('.comments-section').append(data);
                                successRequest = true;
                            }
                        },
                        complete: function(){                            
                            if(successRequest){
                                $('.load-more-comments').html('Load more comments');
                            }
                            else{
                                $('.load-more-comments').remove();
                            }
                        }
                    });
                });
            },
            finalize: function () {
                // JavaScript to be fired on all pages, after page specific JS is fired
            }
        },
        // Home page
        'home': {
            init: function () {
                // JavaScript to be fired on the home page
            },
            finalize: function () {
                // JavaScript to be fired on the home page, after the init JS
            }
        },
        // About us page, note the change from about-us to about_us.
        'about_us': {
            init: function () {
                // JavaScript to be fired on the about us page
            }
        }
    };

    // The routing fires all common scripts, followed by the page specific scripts.
    // Add additional events for more control over timing e.g. a finalize event
    var UTIL = {
        fire: function (func, funcname, args) {
            var fire;
            var namespace = Sage;
            funcname = (funcname === undefined) ? 'init' : funcname;
            fire = func !== '';
            fire = fire && namespace[func];
            fire = fire && typeof namespace[func][funcname] === 'function';

            if (fire) {
                namespace[func][funcname](args);
            }
        },
        loadEvents: function () {
            // Fire common init JS
            UTIL.fire('common');

            // Fire page-specific init JS, and then finalize JS
            $.each(document.body.className.replace(/-/g, '_').split(/\s+/), function (i, classnm) {
                UTIL.fire(classnm);
                UTIL.fire(classnm, 'finalize');
            });

            // Fire common finalize JS
            UTIL.fire('common', 'finalize');
        }
    };

    // Load Events
    $(document).ready(UTIL.loadEvents);
})(jQuery); // Fully reference jQuery after this point.
