<?php
/**
 * Template Name: Volunteering Template - new
 */
?>

<?php 
    $searchpos=get_field('search_position');
?>
    
<?php while (have_posts()) {
    the_post();
    get_template_part('templates/page', 'header'); ?>
    <div class="container">
        <?php
        if ( function_exists('yoast_breadcrumb') ) {
            yoast_breadcrumb( '<p id="breadcrumbs">','</p>' );
        }
        ?>
              
        <div class="row">
            <div class="cms col-md-8">    
            <?php
            if (get_field('is_volunteering_home_page')){
                $myWpQuery = new WP_Query();
                $allWpPages = $myWpQuery->query(['post_type' => 'page', 'post_status' => 'publish']);
                $volunteer =  get_page_by_title('Volunteer');
                $volunteerChildren = get_children( $volunteer->ID, $allWpPages );
            ?>
            <section class="fundraising-section volunteer-nav-section volunteer-nav-section--main">
                <div class="row">
                    <?php foreach ($volunteerChildren as $post) {
                        if (get_post_type() == 'page' && $post->post_status == 'publish') {
                           setup_postdata($post); $featImage = wp_get_attachment_image_src(get_post_thumbnail_id(), "square-thumb") ? wp_get_attachment_image_src(get_post_thumbnail_id(), "square-thumb") : array("/content/themes/aberlour/assets/images/a-logo.png"); ?>
                            <div class="fundraising-box col-xs-12 col-sm-6">
                                <a href="<?php the_permalink(); ?>" class="cover-link" title="<?php the_title(); ?>"> </a>
                                <img class="img-circle img-responsive" src="<?= $featImage[0]; ?>">
                                <h2 class="h2 sub-serv"><strong><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></strong></h2>
                                <?php
                                    if ( has_excerpt()){
                                        ?>
                                <?php the_excerpt();?>
                                <?php } ?>
                            </div>
                        <?php }
                    } ?>
                </div>
            </section>
            <?php wp_reset_query(); 
                }
            ?> 
            
            <?php  
                if( $searchpos=='Top'){
                    get_template_part('templates/volunteering/volunteering-search');
                }               
            ?>
            <?php the_content(); ?>
            <?php
                // Multi section layout
                
                //$sectionRepeater = get_field('section_repeater');
                $navStype = get_field('section_navigation_style');
                $sectionHTML='<div class="multi-section-container">';
                ?>
                <?php if( have_rows('section_repeater') ): ?>
                <section class="mutli-section-wrapper" id="multi-section-wrapper">
                 <?php
                	if ($navStype=='thumbnail'){
                    	?>
                    	<section class="fundraising-section volunteer-nav-section">
                            <div class="row">
                    <?php
                    }else{
                        ?>
                        <div class="dropdown dropdown--update-text dropdown--sticky">
                            <a class="dropdown-toggle dropdown-toggle--scrollupdate" data-toggle="dropdown" href="#">Select a section </a>
                            <ul class="dropdown-menu" role="menu" aria-labelledby="dLabel">
                        <?php
                    }
                ?>	
                	<?php while( have_rows('section_repeater') ): the_row(); 
                    	// vars
                		$image = get_sub_field('navigation_thumbnail');
                		$content = get_sub_field('section_content');
                		$title = get_sub_field('section_title');
                		$titleID = 'section-id_'. str_replace(['&','?',"'",',','.','!','@',' '],"-",$title);
                		
                		
                		$sectionHTML.='<a class="section-anchor" id="'.$titleID.'"></a><div class="section">';
                		$sectionHTML.="<h2 class='h2 sub-serv'><strong>".$title."</strong></h2>";
                		$sectionHTML.='<div class="section-content">'.$content.'</div><a class="to-top" href="#multi-section-wrapper"><i class="fa fa-chevron-up"></i> back to top</a></div>';
                        if ($navStype=='thumbnail'){
                            ?>
                            <div class="fundraising-box col-xs-12 col-sm-6 col-lg-6">
                                <a href="#<?= $titleID;?>" class="cover-link" title="<?php the_title(); ?>"> </a>
                                <div class="flex-img-container">
                                    <img class="img-circle img-responsive" src="<?= $image['sizes'][ 'square-thumb' ]; ?>">
                                </div>
                                <h2 class="h2 sub-serv"><strong><?= $title; ?></strong></h2>
                            </div>
                        <?php
                        }else{
                            ?>
                                <li><a tabindex="-1" href="#<?= $titleID;?>"><?= $title; ?></a></li>
                            <?php
                        }
                        
                		?>
                
                	<?php endwhile; ?>
                
                	<?php
                	if ($navStype=='thumbnail'){
                    	?>
                        	 </div>
                	    </section>
                    <?php
                    }else{
                        ?>
                            </ul>
                        </div>
                        <?php
                    }
                    echo $sectionHTML.'</div>';
                ?>	
                </section>
                <?php endif; ?>
            
         
            <?php if( have_rows('flow_element') ): ?>
                <div class="flex-row flow-diagram-row">
                <?php while( have_rows('flow_element') ): the_row(); ?>
                        <div class="flow-element col-sm-12 col-md-6">
                            <div>
                                <?php the_sub_field('content');?>
                            </div>
                        </div>      
                <?php endwhile; ?>
                </div>
            <?php endif; ?>
            
            <?php  if( $searchpos=='After text'){
                    get_template_part('templates/volunteering/volunteering-search');
                }               
            ?>
        </div>
        <div class="cms col-md-4 sidebar--volunteering">
            <?php the_field('right_column');?>
            <?php // the_post_thumbnail('custom-thumb') ?>
<!--
            <div class="col-md-12">
                <div class="row">
                    <a href="/volunteer-application-form/" class="general-button apply-button">Apply Now</a>
                </div>
            </div>
-->
        </div>
    </div>
</div>
<?php  if( $searchpos=='Bottom'){
        get_template_part('templates/volunteering/volunteering-search');
    }
?>

<?php } ?>


