
<?php
get_template_part('templates/home/home-header');
get_template_part('templates/global/new-service-block');

//Getting services for the postcode search
$serviceMarkers = [];
$serviceLoop = new WP_Query(['post_type' => 'volunteering']);
if ($serviceLoop->have_posts()) {
    $count = 0;
    while ($serviceLoop->have_posts()) {
        $serviceLoop->the_post();
        $map = get_field('google_map');
        if($map) {
            array_push($serviceMarkers, [get_the_title(), $map['lat'], $map['lng'], get_permalink()]);
        }
    }
}
wp_reset_postdata();
?>

<?php
    get_template_part('templates/volunteering/volunteering-search');
?>

<div class="stories-block">
    <div class="container">
        <h2>Volunteer Roles</h2>
        <?php
        $posts = get_field('volunteer_roles', 'option');
        if( $posts ): ?>
            <div class="row">
                <?php foreach( $posts as $post): // variable must be called $post (IMPORTANT) ?>
                    <?php setup_postdata($post); ?>
                    <div class="story-col">
                        <div class="inner-col-story" style="background-image:url('<?php the_post_thumbnail_url(); ?>')">
                            <a href="<?php the_permalink(); ?>">
                                <h3><?php the_title(); ?></h3>
                            </a>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            <?php wp_reset_postdata(); // IMPORTANT - reset the $post object so the rest of the page works correctly ?>
        <?php endif; ?>
    </div>
</div>

<?php
$cta1 = get_field('box_cta_1_volunteering', 'option');
$cta2 = get_field('box_cta_2_volunteering', 'option');
?>

<section class="fluid-bg-container banner-links-support">
    <div class="container-fluid">
        <div class="col-xs-12 col-md-6 green-bg fluid-bg-colour-left support-panel ">
            <h2><?php the_field('box_title_1_volunteering', 'option') ?></h2>
            <?php the_field('box_content_1_volunteering', 'option') ?>
            <a class="general-button" href="<?= $cta1['url'] ?>"><?= $cta1['title']; ?></a>
        </div>
        <div class="col-xs-12 col-md-6 fluid-bg-colour-right front-block support-panel ">
            <h2><?php the_field('box_title_2_volunteering', 'option') ?></h2>
            <?php the_field('box_content_2_volunteering', 'option') ?>
            <a class="general-button" href="<?= $cta2['url'] ?>"><?= $cta2['title']; ?></a>
        </div>
    </div>
</section>
