<?php get_template_part('templates/page', 'header'); ?>

<?php if (!have_posts()) : ?>
    <div class="alert alert-warning">
        <?php _e('Sorry, no results were found.', 'sage'); ?>
    </div>
    <?php get_search_form(); ?>
<?php endif; ?>

<?php
$currentDate = date("Y-m-d",mktime(0,0,0,date("m"),date("d"),date("Y")));

$newEventsQuery = [
        'post_type' => 'events',
        'meta_query'=> array(
            array(
                'key' => 'event_start_date',
                'compare' => '>',
                'value' => $currentDate,
                'type' => 'DATE',
            )),
        'meta_key' => 'event_start_date',
        'orderby' => 'meta_value',
        'order' => 'ASC',
   ];
$newEventsQuery['paged'] = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : 1;

$eventsQuery = new WP_Query($newEventsQuery);
$temp_query = $newEventsQuery;
$wp_query   = NULL;
$wp_query   = $eventsQuery;
?>
<?php
if ( function_exists('yoast_breadcrumb') ) {
    yoast_breadcrumb( '<p id="breadcrumbs">','</p>' );
}
?>
<?php while ($wp_query->have_posts()) : $wp_query->the_post(); ?>
    <?php get_template_part('templates/content', get_post_type() != 'post' ? get_post_type() : get_post_format()); ?>
<?php endwhile;

wp_reset_postdata();
kriesi_pagination();
$wp_query = NULL;
$wp_query = $temp_query;
?>
