<?php wp_reset_query(); ?>

<?php if (is_post_type_archive('events')) { ?>
    <div class="sidebar-buttons">
        <a class="news" href="/news/">News</a>
        <a class="publications" href="/publication/">Publications</a>
    </div>
<?php } elseif(is_post_type_archive('publications')) { ?>
    <div class="sidebar-buttons">
        <a class="news" href="/news/">News</a>
        <a class="events" href="/events/">Events</a>
    </div>
<?php } else { ?>
    <div class="sidebar-buttons">
        <a class="news" href="/events/">Events</a>
        <a class="publications" href="/publication/">Publications</a>
    </div>
<?php } ?>
<?php if (is_post_type_archive('publications')) { ?>
<section class="widget categories-2 widget_categories">
    <h3>Publication Types:</h3>
    <ul>
    <?php
        $args = array(
        'taxonomy' => 'publication_type',
        'orderby' => 'name',
        'parent' => 0
        );
        $categories = get_terms( $args );
        foreach ($categories as $category) {
            echo '<li class="cat-item cat-item-'.$category->slug.'"><a href="'.add_query_arg(array('taxonomy' => 'publication_type', 'term' => $category->slug )).'">'.$category->name.'</a></li>';
        }
    ?>
    </ul>
</section>
<?php } ?>
<?php
if (is_home()) {
    dynamic_sidebar('sidebar-primary');
} ?>

<?php if (get_field('twitter_username', 'option')) { ?>
    <section id="twitterBox" data-handle="<?php the_field('twitter_username','option'); ?>"> </section>
<?php } ?>
