<?php 
$title = get_sub_field('title');
$thankYouTitle = get_sub_field('thank_you_title');
$thankYouDescription = get_sub_field('thank_you_message');
$protocol = "http://";
if(isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on'){
    $protocol = "https://";  
}
$shareUrl = $protocol.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
$contactFormId = get_sub_field('contact_form_id');
?>

<div class="container">
    <div class="row panel--form">
        <div class="col-xs-12 content-panel">
            <h2><?= $title; ?></h2>
            <?= do_shortcode('[contact-form-7 id="'.$contactFormId.'" title="Petition Form"]'); ?>
        </div>
        <div class="col-xs-12 success-message hidden">
            <h2><?= $thankYouTitle; ?></h2>
            <div><?= $thankYouDescription; ?></div>
            <div class="col-xs-12 col-lg-6 mx-auto share-box">
                <?php if(get_sub_field('enable_facebook')) {?>
                    <a class="btn facebook-button" target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=<?= $shareUrl; ?>"><i class="fa fa-facebook"></i> Share on Facebook</a>
                <?php }
                if(get_sub_field('enable_twitter')) {?>                
                    <a class="btn twitter-button" target="_blank" href="https://twitter.com/home?status=<?= $shareUrl; ?>"><i class="fa fa-twitter"></i> Tweet to your followers</a>
                <?php }
                if(get_sub_field('enable_linkedin')) {?>                
                    <a class="btn linkedin-button" target="_blank" href="https://www.linkedin.com/sharing/share-offsite/?url=<?= $shareUrl; ?>"><i class="fa fa-linkedin"></i> Share on Linkedin</a>
                <?php }
                if(get_sub_field('enable_email')) {?>                
                    <a class="btn email-button" target="_blank" href="mailto:?&subject=&body=<?= $shareUrl; ?>"><i class="fa fa-envelope"></i> Send an email</a>
                <?php }
                if(get_sub_field('enable_whatsapp')) {?>                
                    <a class="btn whatsapp-button" target="_blank" href="https://wa.me/?text=<?= urlencode($shareUrl); ?>"><i class="fa fa-whatsapp"></i> Share on Whatsapp</a>
                <?php }
                if(get_sub_field('enable_copy_url')) {?>                
                    <div id="btnCopyToClipboard" class="btn copy-button"><i class="fa fa-link"></i> Copy link</div>
                    <input style="position:absolute; left:-999999%;"id="linkToCopy" type="text" value="<?= $shareUrl; ?>" />
                <?php } ?>
            </div>
        </div>
    </div>
</div>
